/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.EncryptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SseConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SseConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SseConfig.getter(SseConfig::typeAsString)).setter(SseConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyArn").getter(SseConfig.getter(SseConfig::keyArn)).setter(SseConfig.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String keyArn;

    private SseConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.keyArn = builder.keyArn;
    }

    public final EncryptionType type() {
        return EncryptionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SseConfig)) {
            return false;
        }
        SseConfig other = (SseConfig)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.keyArn(), other.keyArn());
    }

    public final String toString() {
        return ToString.builder((String)"SseConfig").add("Type", (Object)this.typeAsString()).add("KeyArn", (Object)this.keyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "keyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SseConfig, T> g) {
        return obj -> g.apply((SseConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String keyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SseConfig model) {
            this.type(model.type);
            this.keyArn(model.keyArn);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public SseConfig build() {
            return new SseConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SseConfig> {
        public Builder type(String var1);

        public Builder type(EncryptionType var1);

        public Builder keyArn(String var1);
    }
}

