/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.RunLogLevel;
import software.amazon.awssdk.services.omics.model.RunResourceDigestsCopier;
import software.amazon.awssdk.services.omics.model.RunStatus;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetRunResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetRunResponse.getter(GetRunResponse::arn)).setter(GetRunResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRunResponse.getter(GetRunResponse::creationTime)).setter(GetRunResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(GetRunResponse.getter(GetRunResponse::definition)).setter(GetRunResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("digest").getter(GetRunResponse.getter(GetRunResponse::digest)).setter(GetRunResponse.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetRunResponse.getter(GetRunResponse::id)).setter(GetRunResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(GetRunResponse.getter(GetRunResponse::logLevelAsString)).setter(GetRunResponse.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRunResponse.getter(GetRunResponse::name)).setter(GetRunResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputUri").getter(GetRunResponse.getter(GetRunResponse::outputUri)).setter(GetRunResponse.setter(Builder::outputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputUri").build()}).build();
    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("parameters").getter(GetRunResponse.getter(GetRunResponse::parameters)).setter(GetRunResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(GetRunResponse.getter(GetRunResponse::priority)).setter(GetRunResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_DIGESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceDigests").getter(GetRunResponse.getter(GetRunResponse::resourceDigests)).setter(GetRunResponse.setter(Builder::resourceDigests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDigests").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetRunResponse.getter(GetRunResponse::roleArn)).setter(GetRunResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runGroupId").getter(GetRunResponse.getter(GetRunResponse::runGroupId)).setter(GetRunResponse.setter(Builder::runGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runGroupId").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(GetRunResponse.getter(GetRunResponse::runId)).setter(GetRunResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetRunResponse.getter(GetRunResponse::startTime)).setter(GetRunResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(GetRunResponse.getter(GetRunResponse::startedBy)).setter(GetRunResponse.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetRunResponse.getter(GetRunResponse::statusAsString)).setter(GetRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetRunResponse.getter(GetRunResponse::statusMessage)).setter(GetRunResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopTime").getter(GetRunResponse.getter(GetRunResponse::stopTime)).setter(GetRunResponse.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(GetRunResponse.getter(GetRunResponse::storageCapacity)).setter(GetRunResponse.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetRunResponse.getter(GetRunResponse::tags)).setter(GetRunResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(GetRunResponse.getter(GetRunResponse::workflowId)).setter(GetRunResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowType").getter(GetRunResponse.getter(GetRunResponse::workflowTypeAsString)).setter(GetRunResponse.setter(Builder::workflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DEFINITION_FIELD, DIGEST_FIELD, ID_FIELD, LOG_LEVEL_FIELD, NAME_FIELD, OUTPUT_URI_FIELD, PARAMETERS_FIELD, PRIORITY_FIELD, RESOURCE_DIGESTS_FIELD, ROLE_ARN_FIELD, RUN_GROUP_ID_FIELD, RUN_ID_FIELD, START_TIME_FIELD, STARTED_BY_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STOP_TIME_FIELD, STORAGE_CAPACITY_FIELD, TAGS_FIELD, WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD));
    private final String arn;
    private final Instant creationTime;
    private final String definition;
    private final String digest;
    private final String id;
    private final String logLevel;
    private final String name;
    private final String outputUri;
    private final Document parameters;
    private final Integer priority;
    private final Map<String, String> resourceDigests;
    private final String roleArn;
    private final String runGroupId;
    private final String runId;
    private final Instant startTime;
    private final String startedBy;
    private final String status;
    private final String statusMessage;
    private final Instant stopTime;
    private final Integer storageCapacity;
    private final Map<String, String> tags;
    private final String workflowId;
    private final String workflowType;

    private GetRunResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.definition = builder.definition;
        this.digest = builder.digest;
        this.id = builder.id;
        this.logLevel = builder.logLevel;
        this.name = builder.name;
        this.outputUri = builder.outputUri;
        this.parameters = builder.parameters;
        this.priority = builder.priority;
        this.resourceDigests = builder.resourceDigests;
        this.roleArn = builder.roleArn;
        this.runGroupId = builder.runGroupId;
        this.runId = builder.runId;
        this.startTime = builder.startTime;
        this.startedBy = builder.startedBy;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.stopTime = builder.stopTime;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String definition() {
        return this.definition;
    }

    public final String digest() {
        return this.digest;
    }

    public final String id() {
        return this.id;
    }

    public final RunLogLevel logLevel() {
        return RunLogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final String name() {
        return this.name;
    }

    public final String outputUri() {
        return this.outputUri;
    }

    public final Document parameters() {
        return this.parameters;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final boolean hasResourceDigests() {
        return this.resourceDigests != null && !(this.resourceDigests instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceDigests() {
        return this.resourceDigests;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String runGroupId() {
        return this.runGroupId;
    }

    public final String runId() {
        return this.runId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final RunStatus status() {
        return RunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(this.workflowType);
    }

    public final String workflowTypeAsString() {
        return this.workflowType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDigests() ? this.resourceDigests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunResponse)) {
            return false;
        }
        GetRunResponse other = (GetRunResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.digest(), other.digest()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outputUri(), other.outputUri()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.priority(), other.priority()) && this.hasResourceDigests() == other.hasResourceDigests() && Objects.equals(this.resourceDigests(), other.resourceDigests()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.runGroupId(), other.runGroupId()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.workflowTypeAsString(), other.workflowTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("Definition", (Object)this.definition()).add("Digest", (Object)this.digest()).add("Id", (Object)this.id()).add("LogLevel", (Object)this.logLevelAsString()).add("Name", (Object)this.name()).add("OutputUri", (Object)this.outputUri()).add("Parameters", (Object)this.parameters()).add("Priority", (Object)this.priority()).add("ResourceDigests", this.hasResourceDigests() ? this.resourceDigests() : null).add("RoleArn", (Object)this.roleArn()).add("RunGroupId", (Object)this.runGroupId()).add("RunId", (Object)this.runId()).add("StartTime", (Object)this.startTime()).add("StartedBy", (Object)this.startedBy()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StopTime", (Object)this.stopTime()).add("StorageCapacity", (Object)this.storageCapacity()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkflowId", (Object)this.workflowId()).add("WorkflowType", (Object)this.workflowTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "outputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "resourceDigests": {
                return Optional.ofNullable(clazz.cast(this.resourceDigests()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "runGroupId": {
                return Optional.ofNullable(clazz.cast(this.runGroupId()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunResponse, T> g) {
        return obj -> g.apply((GetRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String definition;
        private String digest;
        private String id;
        private String logLevel;
        private String name;
        private String outputUri;
        private Document parameters;
        private Integer priority;
        private Map<String, String> resourceDigests = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private String runGroupId;
        private String runId;
        private Instant startTime;
        private String startedBy;
        private String status;
        private String statusMessage;
        private Instant stopTime;
        private Integer storageCapacity;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workflowId;
        private String workflowType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.definition(model.definition);
            this.digest(model.digest);
            this.id(model.id);
            this.logLevel(model.logLevel);
            this.name(model.name);
            this.outputUri(model.outputUri);
            this.parameters(model.parameters);
            this.priority(model.priority);
            this.resourceDigests(model.resourceDigests);
            this.roleArn(model.roleArn);
            this.runGroupId(model.runGroupId);
            this.runId(model.runId);
            this.startTime(model.startTime);
            this.startedBy(model.startedBy);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.stopTime(model.stopTime);
            this.storageCapacity(model.storageCapacity);
            this.tags(model.tags);
            this.workflowId(model.workflowId);
            this.workflowType(model.workflowType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(RunLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final Document getParameters() {
            return this.parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Map<String, String> getResourceDigests() {
            if (this.resourceDigests instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceDigests;
        }

        public final void setResourceDigests(Map<String, String> resourceDigests) {
            this.resourceDigests = RunResourceDigestsCopier.copy(resourceDigests);
        }

        @Override
        public final Builder resourceDigests(Map<String, String> resourceDigests) {
            this.resourceDigests = RunResourceDigestsCopier.copy(resourceDigests);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRunGroupId() {
            return this.runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return this.workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        @Override
        public GetRunResponse build() {
            return new GetRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder definition(String var1);

        public Builder digest(String var1);

        public Builder id(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(RunLogLevel var1);

        public Builder name(String var1);

        public Builder outputUri(String var1);

        public Builder parameters(Document var1);

        public Builder priority(Integer var1);

        public Builder resourceDigests(Map<String, String> var1);

        public Builder roleArn(String var1);

        public Builder runGroupId(String var1);

        public Builder runId(String var1);

        public Builder startTime(Instant var1);

        public Builder startedBy(String var1);

        public Builder status(String var1);

        public Builder status(RunStatus var1);

        public Builder statusMessage(String var1);

        public Builder stopTime(Instant var1);

        public Builder storageCapacity(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder workflowId(String var1);

        public Builder workflowType(String var1);

        public Builder workflowType(WorkflowType var1);
    }
}

