/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse;
import software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary;

public class ListOdbPeeringConnectionsPublisher
implements SdkPublisher<ListOdbPeeringConnectionsResponse> {
    private final OdbAsyncClient client;
    private final ListOdbPeeringConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOdbPeeringConnectionsPublisher(OdbAsyncClient client, ListOdbPeeringConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOdbPeeringConnectionsPublisher(OdbAsyncClient client, ListOdbPeeringConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOdbPeeringConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOdbPeeringConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OdbPeeringConnectionSummary> odbPeeringConnections() {
        Function<ListOdbPeeringConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.odbPeeringConnections() != null) {
                return response.odbPeeringConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOdbPeeringConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOdbPeeringConnectionsResponseFetcher
    implements AsyncPageFetcher<ListOdbPeeringConnectionsResponse> {
        private ListOdbPeeringConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOdbPeeringConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOdbPeeringConnectionsResponse> nextPage(ListOdbPeeringConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListOdbPeeringConnectionsPublisher.this.client.listOdbPeeringConnections(ListOdbPeeringConnectionsPublisher.this.firstRequest);
            }
            return ListOdbPeeringConnectionsPublisher.this.client.listOdbPeeringConnections((ListOdbPeeringConnectionsRequest)((Object)ListOdbPeeringConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

