/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ManagedResourceStatus;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrossRegionS3RestoreSourcesAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrossRegionS3RestoreSourcesAccess> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(CrossRegionS3RestoreSourcesAccess.getter(CrossRegionS3RestoreSourcesAccess::region)).setter(CrossRegionS3RestoreSourcesAccess.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<String>> IPV4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipv4Addresses").getter(CrossRegionS3RestoreSourcesAccess.getter(CrossRegionS3RestoreSourcesAccess::ipv4Addresses)).setter(CrossRegionS3RestoreSourcesAccess.setter(Builder::ipv4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CrossRegionS3RestoreSourcesAccess.getter(CrossRegionS3RestoreSourcesAccess::statusAsString)).setter(CrossRegionS3RestoreSourcesAccess.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, IPV4_ADDRESSES_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CrossRegionS3RestoreSourcesAccess.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final List<String> ipv4Addresses;
    private final String status;

    private CrossRegionS3RestoreSourcesAccess(BuilderImpl builder) {
        this.region = builder.region;
        this.ipv4Addresses = builder.ipv4Addresses;
        this.status = builder.status;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasIpv4Addresses() {
        return this.ipv4Addresses != null && !(this.ipv4Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    public final ManagedResourceStatus status() {
        return ManagedResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Addresses() ? this.ipv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionS3RestoreSourcesAccess)) {
            return false;
        }
        CrossRegionS3RestoreSourcesAccess other = (CrossRegionS3RestoreSourcesAccess)obj;
        return Objects.equals(this.region(), other.region()) && this.hasIpv4Addresses() == other.hasIpv4Addresses() && Objects.equals(this.ipv4Addresses(), other.ipv4Addresses()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CrossRegionS3RestoreSourcesAccess").add("Region", (Object)this.region()).add("Ipv4Addresses", this.hasIpv4Addresses() ? this.ipv4Addresses() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ipv4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv4Addresses()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("region", REGION_FIELD);
        map.put("ipv4Addresses", IPV4_ADDRESSES_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionS3RestoreSourcesAccess, T> g) {
        return obj -> g.apply((CrossRegionS3RestoreSourcesAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private List<String> ipv4Addresses = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionS3RestoreSourcesAccess model) {
            this.region(model.region);
            this.ipv4Addresses(model.ipv4Addresses);
            this.status(model.status);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getIpv4Addresses() {
            if (this.ipv4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv4Addresses;
        }

        public final void setIpv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = StringListCopier.copy(ipv4Addresses);
        }

        @Override
        public final Builder ipv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = StringListCopier.copy(ipv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Addresses(String ... ipv4Addresses) {
            this.ipv4Addresses(Arrays.asList(ipv4Addresses));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public CrossRegionS3RestoreSourcesAccess build() {
            return new CrossRegionS3RestoreSourcesAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrossRegionS3RestoreSourcesAccess> {
        public Builder region(String var1);

        public Builder ipv4Addresses(Collection<String> var1);

        public Builder ipv4Addresses(String ... var1);

        public Builder status(String var1);

        public Builder status(ManagedResourceStatus var1);
    }
}

