/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.CloudVmClusterSummary;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse;

public class ListCloudVmClustersIterable
implements SdkIterable<ListCloudVmClustersResponse> {
    private final OdbClient client;
    private final ListCloudVmClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudVmClustersIterable(OdbClient client, ListCloudVmClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudVmClustersResponseFetcher();
    }

    public Iterator<ListCloudVmClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudVmClusterSummary> cloudVmClusters() {
        Function<ListCloudVmClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudVmClusters() != null) {
                return response.cloudVmClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudVmClustersResponseFetcher
    implements SyncPageFetcher<ListCloudVmClustersResponse> {
        private ListCloudVmClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudVmClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCloudVmClustersResponse nextPage(ListCloudVmClustersResponse previousPage) {
            if (previousPage == null) {
                return ListCloudVmClustersIterable.this.client.listCloudVmClusters(ListCloudVmClustersIterable.this.firstRequest);
            }
            return ListCloudVmClustersIterable.this.client.listCloudVmClusters((ListCloudVmClustersRequest)((Object)ListCloudVmClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

