/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSystemVersionsResponse extends OdbResponse implements
        ToCopyableBuilder<ListSystemVersionsResponse.Builder, ListSystemVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSystemVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SystemVersionSummary>> SYSTEM_VERSIONS_FIELD = SdkField
            .<List<SystemVersionSummary>> builder(MarshallingType.LIST)
            .memberName("systemVersions")
            .getter(getter(ListSystemVersionsResponse::systemVersions))
            .setter(setter(Builder::systemVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SystemVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SystemVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SYSTEM_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SystemVersionSummary> systemVersions;

    private ListSystemVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.systemVersions = builder.systemVersions;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SystemVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSystemVersions() {
        return systemVersions != null && !(systemVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of system versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystemVersions} method.
     * </p>
     * 
     * @return The list of system versions.
     */
    public final List<SystemVersionSummary> systemVersions() {
        return systemVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSystemVersions() ? systemVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSystemVersionsResponse)) {
            return false;
        }
        ListSystemVersionsResponse other = (ListSystemVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSystemVersions() == other.hasSystemVersions()
                && Objects.equals(systemVersions(), other.systemVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSystemVersionsResponse").add("NextToken", nextToken())
                .add("SystemVersions", hasSystemVersions() ? systemVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "systemVersions":
            return Optional.ofNullable(clazz.cast(systemVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("systemVersions", SYSTEM_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSystemVersionsResponse, T> g) {
        return obj -> g.apply((ListSystemVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSystemVersionsResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of system versions.
         * </p>
         * 
         * @param systemVersions
         *        The list of system versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemVersions(Collection<SystemVersionSummary> systemVersions);

        /**
         * <p>
         * The list of system versions.
         * </p>
         * 
         * @param systemVersions
         *        The list of system versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemVersions(SystemVersionSummary... systemVersions);

        /**
         * <p>
         * The list of system versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.SystemVersionSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.odb.model.SystemVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.SystemVersionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #systemVersions(List<SystemVersionSummary>)}.
         * 
         * @param systemVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.SystemVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemVersions(java.util.Collection<SystemVersionSummary>)
         */
        Builder systemVersions(Consumer<SystemVersionSummary.Builder>... systemVersions);
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SystemVersionSummary> systemVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSystemVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            systemVersions(model.systemVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SystemVersionSummary.Builder> getSystemVersions() {
            List<SystemVersionSummary.Builder> result = SystemVersionListCopier.copyToBuilder(this.systemVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemVersions(Collection<SystemVersionSummary.BuilderImpl> systemVersions) {
            this.systemVersions = SystemVersionListCopier.copyFromBuilder(systemVersions);
        }

        @Override
        public final Builder systemVersions(Collection<SystemVersionSummary> systemVersions) {
            this.systemVersions = SystemVersionListCopier.copy(systemVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemVersions(SystemVersionSummary... systemVersions) {
            systemVersions(Arrays.asList(systemVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemVersions(Consumer<SystemVersionSummary.Builder>... systemVersions) {
            systemVersions(Stream.of(systemVersions).map(c -> SystemVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSystemVersionsResponse build() {
            return new ListSystemVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
