/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDbServerResponse extends OdbResponse implements
        ToCopyableBuilder<GetDbServerResponse.Builder, GetDbServerResponse> {
    private static final SdkField<DbServer> DB_SERVER_FIELD = SdkField.<DbServer> builder(MarshallingType.SDK_POJO)
            .memberName("dbServer").getter(getter(GetDbServerResponse::dbServer)).setter(setter(Builder::dbServer))
            .constructor(DbServer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SERVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DbServer dbServer;

    private GetDbServerResponse(BuilderImpl builder) {
        super(builder);
        this.dbServer = builder.dbServer;
    }

    /**
     * <p>
     * The details of the requested database server.
     * </p>
     * 
     * @return The details of the requested database server.
     */
    public final DbServer dbServer() {
        return dbServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDbServerResponse)) {
            return false;
        }
        GetDbServerResponse other = (GetDbServerResponse) obj;
        return Objects.equals(dbServer(), other.dbServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDbServerResponse").add("DbServer", dbServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbServer":
            return Optional.ofNullable(clazz.cast(dbServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbServer", DB_SERVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDbServerResponse, T> g) {
        return obj -> g.apply((GetDbServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDbServerResponse> {
        /**
         * <p>
         * The details of the requested database server.
         * </p>
         * 
         * @param dbServer
         *        The details of the requested database server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServer(DbServer dbServer);

        /**
         * <p>
         * The details of the requested database server.
         * </p>
         * This is a convenience method that creates an instance of the {@link DbServer.Builder} avoiding the need to
         * create one manually via {@link DbServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DbServer.Builder#build()} is called immediately and its result is
         * passed to {@link #dbServer(DbServer)}.
         * 
         * @param dbServer
         *        a consumer that will call methods on {@link DbServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbServer(DbServer)
         */
        default Builder dbServer(Consumer<DbServer.Builder> dbServer) {
            return dbServer(DbServer.builder().applyMutation(dbServer).build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private DbServer dbServer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDbServerResponse model) {
            super(model);
            dbServer(model.dbServer);
        }

        public final DbServer.Builder getDbServer() {
            return dbServer != null ? dbServer.toBuilder() : null;
        }

        public final void setDbServer(DbServer.BuilderImpl dbServer) {
            this.dbServer = dbServer != null ? dbServer.build() : null;
        }

        @Override
        public final Builder dbServer(DbServer dbServer) {
            this.dbServer = dbServer;
            return this;
        }

        @Override
        public GetDbServerResponse build() {
            return new GetDbServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
