/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IORM settings of the Exadata DB system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExadataIormConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ExadataIormConfig.Builder, ExadataIormConfig> {
    private static final SdkField<List<DbIormConfig>> DB_PLANS_FIELD = SdkField
            .<List<DbIormConfig>> builder(MarshallingType.LIST)
            .memberName("dbPlans")
            .getter(getter(ExadataIormConfig::dbPlans))
            .setter(setter(Builder::dbPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DbIormConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DbIormConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LIFECYCLE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleDetails").getter(getter(ExadataIormConfig::lifecycleDetails))
            .setter(setter(Builder::lifecycleDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleDetails").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleState").getter(getter(ExadataIormConfig::lifecycleStateAsString))
            .setter(setter(Builder::lifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleState").build()).build();

    private static final SdkField<String> OBJECTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objective").getter(getter(ExadataIormConfig::objectiveAsString)).setter(setter(Builder::objective))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objective").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PLANS_FIELD,
            LIFECYCLE_DETAILS_FIELD, LIFECYCLE_STATE_FIELD, OBJECTIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DbIormConfig> dbPlans;

    private final String lifecycleDetails;

    private final String lifecycleState;

    private final String objective;

    private ExadataIormConfig(BuilderImpl builder) {
        this.dbPlans = builder.dbPlans;
        this.lifecycleDetails = builder.lifecycleDetails;
        this.lifecycleState = builder.lifecycleState;
        this.objective = builder.objective;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbPlans property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDbPlans() {
        return dbPlans != null && !(dbPlans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IORM settings for all the database in the Exadata DB system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbPlans} method.
     * </p>
     * 
     * @return An array of IORM settings for all the database in the Exadata DB system.
     */
    public final List<DbIormConfig> dbPlans() {
        return dbPlans;
    }

    /**
     * <p>
     * Additional information about the current lifecycleState.
     * </p>
     * 
     * @return Additional information about the current lifecycleState.
     */
    public final String lifecycleDetails() {
        return lifecycleDetails;
    }

    /**
     * <p>
     * The current state of IORM configuration for the Exadata DB system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link IormLifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStateAsString}.
     * </p>
     * 
     * @return The current state of IORM configuration for the Exadata DB system.
     * @see IormLifecycleState
     */
    public final IormLifecycleState lifecycleState() {
        return IormLifecycleState.fromValue(lifecycleState);
    }

    /**
     * <p>
     * The current state of IORM configuration for the Exadata DB system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link IormLifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStateAsString}.
     * </p>
     * 
     * @return The current state of IORM configuration for the Exadata DB system.
     * @see IormLifecycleState
     */
    public final String lifecycleStateAsString() {
        return lifecycleState;
    }

    /**
     * <p>
     * The current value for the IORM objective. The default is AUTO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objective} will
     * return {@link Objective#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectiveAsString}.
     * </p>
     * 
     * @return The current value for the IORM objective. The default is AUTO.
     * @see Objective
     */
    public final Objective objective() {
        return Objective.fromValue(objective);
    }

    /**
     * <p>
     * The current value for the IORM objective. The default is AUTO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objective} will
     * return {@link Objective#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectiveAsString}.
     * </p>
     * 
     * @return The current value for the IORM objective. The default is AUTO.
     * @see Objective
     */
    public final String objectiveAsString() {
        return objective;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDbPlans() ? dbPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExadataIormConfig)) {
            return false;
        }
        ExadataIormConfig other = (ExadataIormConfig) obj;
        return hasDbPlans() == other.hasDbPlans() && Objects.equals(dbPlans(), other.dbPlans())
                && Objects.equals(lifecycleDetails(), other.lifecycleDetails())
                && Objects.equals(lifecycleStateAsString(), other.lifecycleStateAsString())
                && Objects.equals(objectiveAsString(), other.objectiveAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExadataIormConfig").add("DbPlans", hasDbPlans() ? dbPlans() : null)
                .add("LifecycleDetails", lifecycleDetails()).add("LifecycleState", lifecycleStateAsString())
                .add("Objective", objectiveAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbPlans":
            return Optional.ofNullable(clazz.cast(dbPlans()));
        case "lifecycleDetails":
            return Optional.ofNullable(clazz.cast(lifecycleDetails()));
        case "lifecycleState":
            return Optional.ofNullable(clazz.cast(lifecycleStateAsString()));
        case "objective":
            return Optional.ofNullable(clazz.cast(objectiveAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbPlans", DB_PLANS_FIELD);
        map.put("lifecycleDetails", LIFECYCLE_DETAILS_FIELD);
        map.put("lifecycleState", LIFECYCLE_STATE_FIELD);
        map.put("objective", OBJECTIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExadataIormConfig, T> g) {
        return obj -> g.apply((ExadataIormConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExadataIormConfig> {
        /**
         * <p>
         * An array of IORM settings for all the database in the Exadata DB system.
         * </p>
         * 
         * @param dbPlans
         *        An array of IORM settings for all the database in the Exadata DB system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPlans(Collection<DbIormConfig> dbPlans);

        /**
         * <p>
         * An array of IORM settings for all the database in the Exadata DB system.
         * </p>
         * 
         * @param dbPlans
         *        An array of IORM settings for all the database in the Exadata DB system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPlans(DbIormConfig... dbPlans);

        /**
         * <p>
         * An array of IORM settings for all the database in the Exadata DB system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.DbIormConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.odb.model.DbIormConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.DbIormConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dbPlans(List<DbIormConfig>)}.
         * 
         * @param dbPlans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.DbIormConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbPlans(java.util.Collection<DbIormConfig>)
         */
        Builder dbPlans(Consumer<DbIormConfig.Builder>... dbPlans);

        /**
         * <p>
         * Additional information about the current lifecycleState.
         * </p>
         * 
         * @param lifecycleDetails
         *        Additional information about the current lifecycleState.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleDetails(String lifecycleDetails);

        /**
         * <p>
         * The current state of IORM configuration for the Exadata DB system.
         * </p>
         * 
         * @param lifecycleState
         *        The current state of IORM configuration for the Exadata DB system.
         * @see IormLifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IormLifecycleState
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * The current state of IORM configuration for the Exadata DB system.
         * </p>
         * 
         * @param lifecycleState
         *        The current state of IORM configuration for the Exadata DB system.
         * @see IormLifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IormLifecycleState
         */
        Builder lifecycleState(IormLifecycleState lifecycleState);

        /**
         * <p>
         * The current value for the IORM objective. The default is AUTO.
         * </p>
         * 
         * @param objective
         *        The current value for the IORM objective. The default is AUTO.
         * @see Objective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Objective
         */
        Builder objective(String objective);

        /**
         * <p>
         * The current value for the IORM objective. The default is AUTO.
         * </p>
         * 
         * @param objective
         *        The current value for the IORM objective. The default is AUTO.
         * @see Objective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Objective
         */
        Builder objective(Objective objective);
    }

    static final class BuilderImpl implements Builder {
        private List<DbIormConfig> dbPlans = DefaultSdkAutoConstructList.getInstance();

        private String lifecycleDetails;

        private String lifecycleState;

        private String objective;

        private BuilderImpl() {
        }

        private BuilderImpl(ExadataIormConfig model) {
            dbPlans(model.dbPlans);
            lifecycleDetails(model.lifecycleDetails);
            lifecycleState(model.lifecycleState);
            objective(model.objective);
        }

        public final List<DbIormConfig.Builder> getDbPlans() {
            List<DbIormConfig.Builder> result = DbIormConfigListCopier.copyToBuilder(this.dbPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbPlans(Collection<DbIormConfig.BuilderImpl> dbPlans) {
            this.dbPlans = DbIormConfigListCopier.copyFromBuilder(dbPlans);
        }

        @Override
        public final Builder dbPlans(Collection<DbIormConfig> dbPlans) {
            this.dbPlans = DbIormConfigListCopier.copy(dbPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbPlans(DbIormConfig... dbPlans) {
            dbPlans(Arrays.asList(dbPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbPlans(Consumer<DbIormConfig.Builder>... dbPlans) {
            dbPlans(Stream.of(dbPlans).map(c -> DbIormConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLifecycleDetails() {
            return lifecycleDetails;
        }

        public final void setLifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
        }

        @Override
        public final Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            return this;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        public final Builder lifecycleState(IormLifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState == null ? null : lifecycleState.toString());
            return this;
        }

        public final String getObjective() {
            return objective;
        }

        public final void setObjective(String objective) {
            this.objective = objective;
        }

        @Override
        public final Builder objective(String objective) {
            this.objective = objective;
            return this;
        }

        @Override
        public final Builder objective(Objective objective) {
            this.objective(objective == null ? null : objective.toString());
            return this;
        }

        @Override
        public ExadataIormConfig build() {
            return new ExadataIormConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
