/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCloudVmClusterRequest extends OdbRequest implements
        ToCopyableBuilder<DeleteCloudVmClusterRequest.Builder, DeleteCloudVmClusterRequest> {
    private static final SdkField<String> CLOUD_VM_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudVmClusterId").getter(getter(DeleteCloudVmClusterRequest::cloudVmClusterId))
            .setter(setter(Builder::cloudVmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_VM_CLUSTER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cloudVmClusterId;

    private DeleteCloudVmClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cloudVmClusterId = builder.cloudVmClusterId;
    }

    /**
     * <p>
     * The unique identifier of the VM cluster to delete.
     * </p>
     * 
     * @return The unique identifier of the VM cluster to delete.
     */
    public final String cloudVmClusterId() {
        return cloudVmClusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudVmClusterId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCloudVmClusterRequest)) {
            return false;
        }
        DeleteCloudVmClusterRequest other = (DeleteCloudVmClusterRequest) obj;
        return Objects.equals(cloudVmClusterId(), other.cloudVmClusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCloudVmClusterRequest").add("CloudVmClusterId", cloudVmClusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudVmClusterId":
            return Optional.ofNullable(clazz.cast(cloudVmClusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudVmClusterId", CLOUD_VM_CLUSTER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteCloudVmClusterRequest, T> g) {
        return obj -> g.apply((DeleteCloudVmClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCloudVmClusterRequest> {
        /**
         * <p>
         * The unique identifier of the VM cluster to delete.
         * </p>
         * 
         * @param cloudVmClusterId
         *        The unique identifier of the VM cluster to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudVmClusterId(String cloudVmClusterId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String cloudVmClusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCloudVmClusterRequest model) {
            super(model);
            cloudVmClusterId(model.cloudVmClusterId);
        }

        public final String getCloudVmClusterId() {
            return cloudVmClusterId;
        }

        public final void setCloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
        }

        @Override
        public final Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCloudVmClusterRequest build() {
            return new DeleteCloudVmClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
