/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a DB node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DbNodeSummary implements SdkPojo, Serializable, ToCopyableBuilder<DbNodeSummary.Builder, DbNodeSummary> {
    private static final SdkField<String> DB_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbNodeId").getter(getter(DbNodeSummary::dbNodeId)).setter(setter(Builder::dbNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeId").build()).build();

    private static final SdkField<String> DB_NODE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbNodeArn").getter(getter(DbNodeSummary::dbNodeArn)).setter(setter(Builder::dbNodeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DbNodeSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(DbNodeSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> ADDITIONAL_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalDetails").getter(getter(DbNodeSummary::additionalDetails))
            .setter(setter(Builder::additionalDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalDetails").build()).build();

    private static final SdkField<String> BACKUP_IP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backupIpId").getter(getter(DbNodeSummary::backupIpId)).setter(setter(Builder::backupIpId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupIpId").build()).build();

    private static final SdkField<String> BACKUP_VNIC2_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backupVnic2Id").getter(getter(DbNodeSummary::backupVnic2Id)).setter(setter(Builder::backupVnic2Id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupVnic2Id").build()).build();

    private static final SdkField<String> BACKUP_VNIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backupVnicId").getter(getter(DbNodeSummary::backupVnicId)).setter(setter(Builder::backupVnicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupVnicId").build()).build();

    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCount").getter(getter(DbNodeSummary::cpuCoreCount)).setter(setter(Builder::cpuCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()).build();

    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs")
            .getter(getter(DbNodeSummary::dbNodeStorageSizeInGBs)).setter(setter(Builder::dbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<String> DB_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbServerId").getter(getter(DbNodeSummary::dbServerId)).setter(setter(Builder::dbServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerId").build()).build();

    private static final SdkField<String> DB_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbSystemId").getter(getter(DbNodeSummary::dbSystemId)).setter(setter(Builder::dbSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbSystemId").build()).build();

    private static final SdkField<String> FAULT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("faultDomain").getter(getter(DbNodeSummary::faultDomain)).setter(setter(Builder::faultDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("faultDomain").build()).build();

    private static final SdkField<String> HOST_IP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostIpId").getter(getter(DbNodeSummary::hostIpId)).setter(setter(Builder::hostIpId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostIpId").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(DbNodeSummary::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> OCID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ocid")
            .getter(getter(DbNodeSummary::ocid)).setter(setter(Builder::ocid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()).build();

    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociResourceAnchorName").getter(getter(DbNodeSummary::ociResourceAnchorName))
            .setter(setter(Builder::ociResourceAnchorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build())
            .build();

    private static final SdkField<String> MAINTENANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("maintenanceType").getter(getter(DbNodeSummary::maintenanceTypeAsString))
            .setter(setter(Builder::maintenanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceType").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInGBs").getter(getter(DbNodeSummary::memorySizeInGBs))
            .setter(setter(Builder::memorySizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()).build();

    private static final SdkField<Integer> SOFTWARE_STORAGE_SIZE_IN_GB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("softwareStorageSizeInGB")
            .getter(getter(DbNodeSummary::softwareStorageSizeInGB)).setter(setter(Builder::softwareStorageSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareStorageSizeInGB").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DbNodeSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TIME_MAINTENANCE_WINDOW_END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeMaintenanceWindowEnd").getter(getter(DbNodeSummary::timeMaintenanceWindowEnd))
            .setter(setter(Builder::timeMaintenanceWindowEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeMaintenanceWindowEnd").build())
            .build();

    private static final SdkField<String> TIME_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("timeMaintenanceWindowStart")
            .getter(getter(DbNodeSummary::timeMaintenanceWindowStart))
            .setter(setter(Builder::timeMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeMaintenanceWindowStart").build())
            .build();

    private static final SdkField<Integer> TOTAL_CPU_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalCpuCoreCount").getter(getter(DbNodeSummary::totalCpuCoreCount))
            .setter(setter(Builder::totalCpuCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCpuCoreCount").build()).build();

    private static final SdkField<String> VNIC2_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnic2Id").getter(getter(DbNodeSummary::vnic2Id)).setter(setter(Builder::vnic2Id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnic2Id").build()).build();

    private static final SdkField<String> VNIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vnicId")
            .getter(getter(DbNodeSummary::vnicId)).setter(setter(Builder::vnicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnicId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NODE_ID_FIELD,
            DB_NODE_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ADDITIONAL_DETAILS_FIELD, BACKUP_IP_ID_FIELD,
            BACKUP_VNIC2_ID_FIELD, BACKUP_VNIC_ID_FIELD, CPU_CORE_COUNT_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD,
            DB_SERVER_ID_FIELD, DB_SYSTEM_ID_FIELD, FAULT_DOMAIN_FIELD, HOST_IP_ID_FIELD, HOSTNAME_FIELD, OCID_FIELD,
            OCI_RESOURCE_ANCHOR_NAME_FIELD, MAINTENANCE_TYPE_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, SOFTWARE_STORAGE_SIZE_IN_GB_FIELD,
            CREATED_AT_FIELD, TIME_MAINTENANCE_WINDOW_END_FIELD, TIME_MAINTENANCE_WINDOW_START_FIELD, TOTAL_CPU_CORE_COUNT_FIELD,
            VNIC2_ID_FIELD, VNIC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbNodeId;

    private final String dbNodeArn;

    private final String status;

    private final String statusReason;

    private final String additionalDetails;

    private final String backupIpId;

    private final String backupVnic2Id;

    private final String backupVnicId;

    private final Integer cpuCoreCount;

    private final Integer dbNodeStorageSizeInGBs;

    private final String dbServerId;

    private final String dbSystemId;

    private final String faultDomain;

    private final String hostIpId;

    private final String hostname;

    private final String ocid;

    private final String ociResourceAnchorName;

    private final String maintenanceType;

    private final Integer memorySizeInGBs;

    private final Integer softwareStorageSizeInGB;

    private final Instant createdAt;

    private final String timeMaintenanceWindowEnd;

    private final String timeMaintenanceWindowStart;

    private final Integer totalCpuCoreCount;

    private final String vnic2Id;

    private final String vnicId;

    private DbNodeSummary(BuilderImpl builder) {
        this.dbNodeId = builder.dbNodeId;
        this.dbNodeArn = builder.dbNodeArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.additionalDetails = builder.additionalDetails;
        this.backupIpId = builder.backupIpId;
        this.backupVnic2Id = builder.backupVnic2Id;
        this.backupVnicId = builder.backupVnicId;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServerId = builder.dbServerId;
        this.dbSystemId = builder.dbSystemId;
        this.faultDomain = builder.faultDomain;
        this.hostIpId = builder.hostIpId;
        this.hostname = builder.hostname;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.maintenanceType = builder.maintenanceType;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.softwareStorageSizeInGB = builder.softwareStorageSizeInGB;
        this.createdAt = builder.createdAt;
        this.timeMaintenanceWindowEnd = builder.timeMaintenanceWindowEnd;
        this.timeMaintenanceWindowStart = builder.timeMaintenanceWindowStart;
        this.totalCpuCoreCount = builder.totalCpuCoreCount;
        this.vnic2Id = builder.vnic2Id;
        this.vnicId = builder.vnicId;
    }

    /**
     * <p>
     * The unique identifier of the DB node.
     * </p>
     * 
     * @return The unique identifier of the DB node.
     */
    public final String dbNodeId() {
        return dbNodeId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DB node.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DB node.
     */
    public final String dbNodeArn() {
        return dbNodeArn;
    }

    /**
     * <p>
     * The current status of the DB node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DbNodeResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the DB node.
     * @see DbNodeResourceStatus
     */
    public final DbNodeResourceStatus status() {
        return DbNodeResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the DB node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DbNodeResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the DB node.
     * @see DbNodeResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the DB node.
     * </p>
     * 
     * @return Additional information about the status of the DB node.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Additional information about the planned maintenance.
     * </p>
     * 
     * @return Additional information about the planned maintenance.
     */
    public final String additionalDetails() {
        return additionalDetails;
    }

    /**
     * <p>
     * The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
     * </p>
     * 
     * @return The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
     */
    public final String backupIpId() {
        return backupIpId;
    }

    /**
     * <p>
     * The OCID of the second backup virtual network interface card (VNIC) for the DB node.
     * </p>
     * 
     * @return The OCID of the second backup virtual network interface card (VNIC) for the DB node.
     */
    public final String backupVnic2Id() {
        return backupVnic2Id;
    }

    /**
     * <p>
     * The OCID of the backup VNIC for the DB node.
     * </p>
     * 
     * @return The OCID of the backup VNIC for the DB node.
     */
    public final String backupVnicId() {
        return backupVnicId;
    }

    /**
     * <p>
     * The number of CPU cores enabled on the DB node.
     * </p>
     * 
     * @return The number of CPU cores enabled on the DB node.
     */
    public final Integer cpuCoreCount() {
        return cpuCoreCount;
    }

    /**
     * <p>
     * The amount of local node storage, in gigabytes (GB), that's allocated on the DB node.
     * </p>
     * 
     * @return The amount of local node storage, in gigabytes (GB), that's allocated on the DB node.
     */
    public final Integer dbNodeStorageSizeInGBs() {
        return dbNodeStorageSizeInGBs;
    }

    /**
     * <p>
     * The unique identifier of the database server that's associated with the DB node.
     * </p>
     * 
     * @return The unique identifier of the database server that's associated with the DB node.
     */
    public final String dbServerId() {
        return dbServerId;
    }

    /**
     * <p>
     * The OCID of the DB system.
     * </p>
     * 
     * @return The OCID of the DB system.
     */
    public final String dbSystemId() {
        return dbSystemId;
    }

    /**
     * <p>
     * The name of the fault domain where the DB node is located.
     * </p>
     * 
     * @return The name of the fault domain where the DB node is located.
     */
    public final String faultDomain() {
        return faultDomain;
    }

    /**
     * <p>
     * The OCID of the host IP address that's associated with the DB node.
     * </p>
     * 
     * @return The OCID of the host IP address that's associated with the DB node.
     */
    public final String hostIpId() {
        return hostIpId;
    }

    /**
     * <p>
     * The host name for the DB node.
     * </p>
     * 
     * @return The host name for the DB node.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The OCID of the DB node.
     * </p>
     * 
     * @return The OCID of the DB node.
     */
    public final String ocid() {
        return ocid;
    }

    /**
     * <p>
     * The name of the OCI resource anchor for the DB node.
     * </p>
     * 
     * @return The name of the OCI resource anchor for the DB node.
     */
    public final String ociResourceAnchorName() {
        return ociResourceAnchorName;
    }

    /**
     * <p>
     * The type of maintenance the DB node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceType}
     * will return {@link DbNodeMaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maintenanceTypeAsString}.
     * </p>
     * 
     * @return The type of maintenance the DB node.
     * @see DbNodeMaintenanceType
     */
    public final DbNodeMaintenanceType maintenanceType() {
        return DbNodeMaintenanceType.fromValue(maintenanceType);
    }

    /**
     * <p>
     * The type of maintenance the DB node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceType}
     * will return {@link DbNodeMaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maintenanceTypeAsString}.
     * </p>
     * 
     * @return The type of maintenance the DB node.
     * @see DbNodeMaintenanceType
     */
    public final String maintenanceTypeAsString() {
        return maintenanceType;
    }

    /**
     * <p>
     * The amount of memory, in gigabytes (GB), that allocated on the DB node.
     * </p>
     * 
     * @return The amount of memory, in gigabytes (GB), that allocated on the DB node.
     */
    public final Integer memorySizeInGBs() {
        return memorySizeInGBs;
    }

    /**
     * <p>
     * The size of the block storage volume, in gigabytes (GB), that's allocated for the DB system. This attribute
     * applies only for virtual machine DB systems.
     * </p>
     * 
     * @return The size of the block storage volume, in gigabytes (GB), that's allocated for the DB system. This
     *         attribute applies only for virtual machine DB systems.
     */
    public final Integer softwareStorageSizeInGB() {
        return softwareStorageSizeInGB;
    }

    /**
     * <p>
     * The date and time when the DB node was created.
     * </p>
     * 
     * @return The date and time when the DB node was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The end date and time of the maintenance window.
     * </p>
     * 
     * @return The end date and time of the maintenance window.
     */
    public final String timeMaintenanceWindowEnd() {
        return timeMaintenanceWindowEnd;
    }

    /**
     * <p>
     * The start date and time of the maintenance window.
     * </p>
     * 
     * @return The start date and time of the maintenance window.
     */
    public final String timeMaintenanceWindowStart() {
        return timeMaintenanceWindowStart;
    }

    /**
     * <p>
     * The total number of CPU cores reserved on the DB node.
     * </p>
     * 
     * @return The total number of CPU cores reserved on the DB node.
     */
    public final Integer totalCpuCoreCount() {
        return totalCpuCoreCount;
    }

    /**
     * <p>
     * The OCID of the second VNIC.
     * </p>
     * 
     * @return The OCID of the second VNIC.
     */
    public final String vnic2Id() {
        return vnic2Id;
    }

    /**
     * <p>
     * The OCID of the VNIC.
     * </p>
     * 
     * @return The OCID of the VNIC.
     */
    public final String vnicId() {
        return vnicId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(additionalDetails());
        hashCode = 31 * hashCode + Objects.hashCode(backupIpId());
        hashCode = 31 * hashCode + Objects.hashCode(backupVnic2Id());
        hashCode = 31 * hashCode + Objects.hashCode(backupVnicId());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbServerId());
        hashCode = 31 * hashCode + Objects.hashCode(dbSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(faultDomain());
        hashCode = 31 * hashCode + Objects.hashCode(hostIpId());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(ocid());
        hashCode = 31 * hashCode + Objects.hashCode(ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(softwareStorageSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(timeMaintenanceWindowEnd());
        hashCode = 31 * hashCode + Objects.hashCode(timeMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(totalCpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(vnic2Id());
        hashCode = 31 * hashCode + Objects.hashCode(vnicId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbNodeSummary)) {
            return false;
        }
        DbNodeSummary other = (DbNodeSummary) obj;
        return Objects.equals(dbNodeId(), other.dbNodeId()) && Objects.equals(dbNodeArn(), other.dbNodeArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(additionalDetails(), other.additionalDetails())
                && Objects.equals(backupIpId(), other.backupIpId()) && Objects.equals(backupVnic2Id(), other.backupVnic2Id())
                && Objects.equals(backupVnicId(), other.backupVnicId()) && Objects.equals(cpuCoreCount(), other.cpuCoreCount())
                && Objects.equals(dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs())
                && Objects.equals(dbServerId(), other.dbServerId()) && Objects.equals(dbSystemId(), other.dbSystemId())
                && Objects.equals(faultDomain(), other.faultDomain()) && Objects.equals(hostIpId(), other.hostIpId())
                && Objects.equals(hostname(), other.hostname()) && Objects.equals(ocid(), other.ocid())
                && Objects.equals(ociResourceAnchorName(), other.ociResourceAnchorName())
                && Objects.equals(maintenanceTypeAsString(), other.maintenanceTypeAsString())
                && Objects.equals(memorySizeInGBs(), other.memorySizeInGBs())
                && Objects.equals(softwareStorageSizeInGB(), other.softwareStorageSizeInGB())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(timeMaintenanceWindowEnd(), other.timeMaintenanceWindowEnd())
                && Objects.equals(timeMaintenanceWindowStart(), other.timeMaintenanceWindowStart())
                && Objects.equals(totalCpuCoreCount(), other.totalCpuCoreCount()) && Objects.equals(vnic2Id(), other.vnic2Id())
                && Objects.equals(vnicId(), other.vnicId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DbNodeSummary").add("DbNodeId", dbNodeId()).add("DbNodeArn", dbNodeArn())
                .add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("AdditionalDetails", additionalDetails()).add("BackupIpId", backupIpId())
                .add("BackupVnic2Id", backupVnic2Id()).add("BackupVnicId", backupVnicId()).add("CpuCoreCount", cpuCoreCount())
                .add("DbNodeStorageSizeInGBs", dbNodeStorageSizeInGBs()).add("DbServerId", dbServerId())
                .add("DbSystemId", dbSystemId()).add("FaultDomain", faultDomain()).add("HostIpId", hostIpId())
                .add("Hostname", hostname()).add("Ocid", ocid()).add("OciResourceAnchorName", ociResourceAnchorName())
                .add("MaintenanceType", maintenanceTypeAsString()).add("MemorySizeInGBs", memorySizeInGBs())
                .add("SoftwareStorageSizeInGB", softwareStorageSizeInGB()).add("CreatedAt", createdAt())
                .add("TimeMaintenanceWindowEnd", timeMaintenanceWindowEnd())
                .add("TimeMaintenanceWindowStart", timeMaintenanceWindowStart()).add("TotalCpuCoreCount", totalCpuCoreCount())
                .add("Vnic2Id", vnic2Id()).add("VnicId", vnicId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbNodeId":
            return Optional.ofNullable(clazz.cast(dbNodeId()));
        case "dbNodeArn":
            return Optional.ofNullable(clazz.cast(dbNodeArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "additionalDetails":
            return Optional.ofNullable(clazz.cast(additionalDetails()));
        case "backupIpId":
            return Optional.ofNullable(clazz.cast(backupIpId()));
        case "backupVnic2Id":
            return Optional.ofNullable(clazz.cast(backupVnic2Id()));
        case "backupVnicId":
            return Optional.ofNullable(clazz.cast(backupVnicId()));
        case "cpuCoreCount":
            return Optional.ofNullable(clazz.cast(cpuCoreCount()));
        case "dbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dbNodeStorageSizeInGBs()));
        case "dbServerId":
            return Optional.ofNullable(clazz.cast(dbServerId()));
        case "dbSystemId":
            return Optional.ofNullable(clazz.cast(dbSystemId()));
        case "faultDomain":
            return Optional.ofNullable(clazz.cast(faultDomain()));
        case "hostIpId":
            return Optional.ofNullable(clazz.cast(hostIpId()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "ocid":
            return Optional.ofNullable(clazz.cast(ocid()));
        case "ociResourceAnchorName":
            return Optional.ofNullable(clazz.cast(ociResourceAnchorName()));
        case "maintenanceType":
            return Optional.ofNullable(clazz.cast(maintenanceTypeAsString()));
        case "memorySizeInGBs":
            return Optional.ofNullable(clazz.cast(memorySizeInGBs()));
        case "softwareStorageSizeInGB":
            return Optional.ofNullable(clazz.cast(softwareStorageSizeInGB()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "timeMaintenanceWindowEnd":
            return Optional.ofNullable(clazz.cast(timeMaintenanceWindowEnd()));
        case "timeMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(timeMaintenanceWindowStart()));
        case "totalCpuCoreCount":
            return Optional.ofNullable(clazz.cast(totalCpuCoreCount()));
        case "vnic2Id":
            return Optional.ofNullable(clazz.cast(vnic2Id()));
        case "vnicId":
            return Optional.ofNullable(clazz.cast(vnicId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbNodeId", DB_NODE_ID_FIELD);
        map.put("dbNodeArn", DB_NODE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("additionalDetails", ADDITIONAL_DETAILS_FIELD);
        map.put("backupIpId", BACKUP_IP_ID_FIELD);
        map.put("backupVnic2Id", BACKUP_VNIC2_ID_FIELD);
        map.put("backupVnicId", BACKUP_VNIC_ID_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServerId", DB_SERVER_ID_FIELD);
        map.put("dbSystemId", DB_SYSTEM_ID_FIELD);
        map.put("faultDomain", FAULT_DOMAIN_FIELD);
        map.put("hostIpId", HOST_IP_ID_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("maintenanceType", MAINTENANCE_TYPE_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("softwareStorageSizeInGB", SOFTWARE_STORAGE_SIZE_IN_GB_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("timeMaintenanceWindowEnd", TIME_MAINTENANCE_WINDOW_END_FIELD);
        map.put("timeMaintenanceWindowStart", TIME_MAINTENANCE_WINDOW_START_FIELD);
        map.put("totalCpuCoreCount", TOTAL_CPU_CORE_COUNT_FIELD);
        map.put("vnic2Id", VNIC2_ID_FIELD);
        map.put("vnicId", VNIC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbNodeSummary, T> g) {
        return obj -> g.apply((DbNodeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DbNodeSummary> {
        /**
         * <p>
         * The unique identifier of the DB node.
         * </p>
         * 
         * @param dbNodeId
         *        The unique identifier of the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeId(String dbNodeId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DB node.
         * </p>
         * 
         * @param dbNodeArn
         *        The Amazon Resource Name (ARN) of the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeArn(String dbNodeArn);

        /**
         * <p>
         * The current status of the DB node.
         * </p>
         * 
         * @param status
         *        The current status of the DB node.
         * @see DbNodeResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbNodeResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the DB node.
         * </p>
         * 
         * @param status
         *        The current status of the DB node.
         * @see DbNodeResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbNodeResourceStatus
         */
        Builder status(DbNodeResourceStatus status);

        /**
         * <p>
         * Additional information about the status of the DB node.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the status of the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Additional information about the planned maintenance.
         * </p>
         * 
         * @param additionalDetails
         *        Additional information about the planned maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetails(String additionalDetails);

        /**
         * <p>
         * The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
         * </p>
         * 
         * @param backupIpId
         *        The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupIpId(String backupIpId);

        /**
         * <p>
         * The OCID of the second backup virtual network interface card (VNIC) for the DB node.
         * </p>
         * 
         * @param backupVnic2Id
         *        The OCID of the second backup virtual network interface card (VNIC) for the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVnic2Id(String backupVnic2Id);

        /**
         * <p>
         * The OCID of the backup VNIC for the DB node.
         * </p>
         * 
         * @param backupVnicId
         *        The OCID of the backup VNIC for the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVnicId(String backupVnicId);

        /**
         * <p>
         * The number of CPU cores enabled on the DB node.
         * </p>
         * 
         * @param cpuCoreCount
         *        The number of CPU cores enabled on the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCount(Integer cpuCoreCount);

        /**
         * <p>
         * The amount of local node storage, in gigabytes (GB), that's allocated on the DB node.
         * </p>
         * 
         * @param dbNodeStorageSizeInGBs
         *        The amount of local node storage, in gigabytes (GB), that's allocated on the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs);

        /**
         * <p>
         * The unique identifier of the database server that's associated with the DB node.
         * </p>
         * 
         * @param dbServerId
         *        The unique identifier of the database server that's associated with the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServerId(String dbServerId);

        /**
         * <p>
         * The OCID of the DB system.
         * </p>
         * 
         * @param dbSystemId
         *        The OCID of the DB system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSystemId(String dbSystemId);

        /**
         * <p>
         * The name of the fault domain where the DB node is located.
         * </p>
         * 
         * @param faultDomain
         *        The name of the fault domain where the DB node is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultDomain(String faultDomain);

        /**
         * <p>
         * The OCID of the host IP address that's associated with the DB node.
         * </p>
         * 
         * @param hostIpId
         *        The OCID of the host IP address that's associated with the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIpId(String hostIpId);

        /**
         * <p>
         * The host name for the DB node.
         * </p>
         * 
         * @param hostname
         *        The host name for the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The OCID of the DB node.
         * </p>
         * 
         * @param ocid
         *        The OCID of the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocid(String ocid);

        /**
         * <p>
         * The name of the OCI resource anchor for the DB node.
         * </p>
         * 
         * @param ociResourceAnchorName
         *        The name of the OCI resource anchor for the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociResourceAnchorName(String ociResourceAnchorName);

        /**
         * <p>
         * The type of maintenance the DB node.
         * </p>
         * 
         * @param maintenanceType
         *        The type of maintenance the DB node.
         * @see DbNodeMaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbNodeMaintenanceType
         */
        Builder maintenanceType(String maintenanceType);

        /**
         * <p>
         * The type of maintenance the DB node.
         * </p>
         * 
         * @param maintenanceType
         *        The type of maintenance the DB node.
         * @see DbNodeMaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbNodeMaintenanceType
         */
        Builder maintenanceType(DbNodeMaintenanceType maintenanceType);

        /**
         * <p>
         * The amount of memory, in gigabytes (GB), that allocated on the DB node.
         * </p>
         * 
         * @param memorySizeInGBs
         *        The amount of memory, in gigabytes (GB), that allocated on the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInGBs(Integer memorySizeInGBs);

        /**
         * <p>
         * The size of the block storage volume, in gigabytes (GB), that's allocated for the DB system. This attribute
         * applies only for virtual machine DB systems.
         * </p>
         * 
         * @param softwareStorageSizeInGB
         *        The size of the block storage volume, in gigabytes (GB), that's allocated for the DB system. This
         *        attribute applies only for virtual machine DB systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareStorageSizeInGB(Integer softwareStorageSizeInGB);

        /**
         * <p>
         * The date and time when the DB node was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the DB node was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The end date and time of the maintenance window.
         * </p>
         * 
         * @param timeMaintenanceWindowEnd
         *        The end date and time of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeMaintenanceWindowEnd(String timeMaintenanceWindowEnd);

        /**
         * <p>
         * The start date and time of the maintenance window.
         * </p>
         * 
         * @param timeMaintenanceWindowStart
         *        The start date and time of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeMaintenanceWindowStart(String timeMaintenanceWindowStart);

        /**
         * <p>
         * The total number of CPU cores reserved on the DB node.
         * </p>
         * 
         * @param totalCpuCoreCount
         *        The total number of CPU cores reserved on the DB node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCpuCoreCount(Integer totalCpuCoreCount);

        /**
         * <p>
         * The OCID of the second VNIC.
         * </p>
         * 
         * @param vnic2Id
         *        The OCID of the second VNIC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnic2Id(String vnic2Id);

        /**
         * <p>
         * The OCID of the VNIC.
         * </p>
         * 
         * @param vnicId
         *        The OCID of the VNIC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnicId(String vnicId);
    }

    static final class BuilderImpl implements Builder {
        private String dbNodeId;

        private String dbNodeArn;

        private String status;

        private String statusReason;

        private String additionalDetails;

        private String backupIpId;

        private String backupVnic2Id;

        private String backupVnicId;

        private Integer cpuCoreCount;

        private Integer dbNodeStorageSizeInGBs;

        private String dbServerId;

        private String dbSystemId;

        private String faultDomain;

        private String hostIpId;

        private String hostname;

        private String ocid;

        private String ociResourceAnchorName;

        private String maintenanceType;

        private Integer memorySizeInGBs;

        private Integer softwareStorageSizeInGB;

        private Instant createdAt;

        private String timeMaintenanceWindowEnd;

        private String timeMaintenanceWindowStart;

        private Integer totalCpuCoreCount;

        private String vnic2Id;

        private String vnicId;

        private BuilderImpl() {
        }

        private BuilderImpl(DbNodeSummary model) {
            dbNodeId(model.dbNodeId);
            dbNodeArn(model.dbNodeArn);
            status(model.status);
            statusReason(model.statusReason);
            additionalDetails(model.additionalDetails);
            backupIpId(model.backupIpId);
            backupVnic2Id(model.backupVnic2Id);
            backupVnicId(model.backupVnicId);
            cpuCoreCount(model.cpuCoreCount);
            dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            dbServerId(model.dbServerId);
            dbSystemId(model.dbSystemId);
            faultDomain(model.faultDomain);
            hostIpId(model.hostIpId);
            hostname(model.hostname);
            ocid(model.ocid);
            ociResourceAnchorName(model.ociResourceAnchorName);
            maintenanceType(model.maintenanceType);
            memorySizeInGBs(model.memorySizeInGBs);
            softwareStorageSizeInGB(model.softwareStorageSizeInGB);
            createdAt(model.createdAt);
            timeMaintenanceWindowEnd(model.timeMaintenanceWindowEnd);
            timeMaintenanceWindowStart(model.timeMaintenanceWindowStart);
            totalCpuCoreCount(model.totalCpuCoreCount);
            vnic2Id(model.vnic2Id);
            vnicId(model.vnicId);
        }

        public final String getDbNodeId() {
            return dbNodeId;
        }

        public final void setDbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
        }

        @Override
        public final Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public final String getDbNodeArn() {
            return dbNodeArn;
        }

        public final void setDbNodeArn(String dbNodeArn) {
            this.dbNodeArn = dbNodeArn;
        }

        @Override
        public final Builder dbNodeArn(String dbNodeArn) {
            this.dbNodeArn = dbNodeArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DbNodeResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAdditionalDetails() {
            return additionalDetails;
        }

        public final void setAdditionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
        }

        @Override
        public final Builder additionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public final String getBackupIpId() {
            return backupIpId;
        }

        public final void setBackupIpId(String backupIpId) {
            this.backupIpId = backupIpId;
        }

        @Override
        public final Builder backupIpId(String backupIpId) {
            this.backupIpId = backupIpId;
            return this;
        }

        public final String getBackupVnic2Id() {
            return backupVnic2Id;
        }

        public final void setBackupVnic2Id(String backupVnic2Id) {
            this.backupVnic2Id = backupVnic2Id;
        }

        @Override
        public final Builder backupVnic2Id(String backupVnic2Id) {
            this.backupVnic2Id = backupVnic2Id;
            return this;
        }

        public final String getBackupVnicId() {
            return backupVnicId;
        }

        public final void setBackupVnicId(String backupVnicId) {
            this.backupVnicId = backupVnicId;
        }

        @Override
        public final Builder backupVnicId(String backupVnicId) {
            this.backupVnicId = backupVnicId;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final String getDbServerId() {
            return dbServerId;
        }

        public final void setDbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
        }

        @Override
        public final Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            return this;
        }

        public final String getDbSystemId() {
            return dbSystemId;
        }

        public final void setDbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
        }

        @Override
        public final Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public final String getFaultDomain() {
            return faultDomain;
        }

        public final void setFaultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
        }

        @Override
        public final Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            return this;
        }

        public final String getHostIpId() {
            return hostIpId;
        }

        public final void setHostIpId(String hostIpId) {
            this.hostIpId = hostIpId;
        }

        @Override
        public final Builder hostIpId(String hostIpId) {
            this.hostIpId = hostIpId;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getOcid() {
            return ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getMaintenanceType() {
            return maintenanceType;
        }

        public final void setMaintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
        }

        @Override
        public final Builder maintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        @Override
        public final Builder maintenanceType(DbNodeMaintenanceType maintenanceType) {
            this.maintenanceType(maintenanceType == null ? null : maintenanceType.toString());
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getSoftwareStorageSizeInGB() {
            return softwareStorageSizeInGB;
        }

        public final void setSoftwareStorageSizeInGB(Integer softwareStorageSizeInGB) {
            this.softwareStorageSizeInGB = softwareStorageSizeInGB;
        }

        @Override
        public final Builder softwareStorageSizeInGB(Integer softwareStorageSizeInGB) {
            this.softwareStorageSizeInGB = softwareStorageSizeInGB;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getTimeMaintenanceWindowEnd() {
            return timeMaintenanceWindowEnd;
        }

        public final void setTimeMaintenanceWindowEnd(String timeMaintenanceWindowEnd) {
            this.timeMaintenanceWindowEnd = timeMaintenanceWindowEnd;
        }

        @Override
        public final Builder timeMaintenanceWindowEnd(String timeMaintenanceWindowEnd) {
            this.timeMaintenanceWindowEnd = timeMaintenanceWindowEnd;
            return this;
        }

        public final String getTimeMaintenanceWindowStart() {
            return timeMaintenanceWindowStart;
        }

        public final void setTimeMaintenanceWindowStart(String timeMaintenanceWindowStart) {
            this.timeMaintenanceWindowStart = timeMaintenanceWindowStart;
        }

        @Override
        public final Builder timeMaintenanceWindowStart(String timeMaintenanceWindowStart) {
            this.timeMaintenanceWindowStart = timeMaintenanceWindowStart;
            return this;
        }

        public final Integer getTotalCpuCoreCount() {
            return totalCpuCoreCount;
        }

        public final void setTotalCpuCoreCount(Integer totalCpuCoreCount) {
            this.totalCpuCoreCount = totalCpuCoreCount;
        }

        @Override
        public final Builder totalCpuCoreCount(Integer totalCpuCoreCount) {
            this.totalCpuCoreCount = totalCpuCoreCount;
            return this;
        }

        public final String getVnic2Id() {
            return vnic2Id;
        }

        public final void setVnic2Id(String vnic2Id) {
            this.vnic2Id = vnic2Id;
        }

        @Override
        public final Builder vnic2Id(String vnic2Id) {
            this.vnic2Id = vnic2Id;
            return this;
        }

        public final String getVnicId() {
            return vnicId;
        }

        public final void setVnicId(String vnicId) {
            this.vnicId = vnicId;
        }

        @Override
        public final Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        @Override
        public DbNodeSummary build() {
            return new DbNodeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
