/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IORM configuration settings for the database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DbIormConfig implements SdkPojo, Serializable, ToCopyableBuilder<DbIormConfig.Builder, DbIormConfig> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dbName")
            .getter(getter(DbIormConfig::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbName").build()).build();

    private static final SdkField<String> FLASH_CACHE_LIMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flashCacheLimit").getter(getter(DbIormConfig::flashCacheLimit)).setter(setter(Builder::flashCacheLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flashCacheLimit").build()).build();

    private static final SdkField<Integer> SHARE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("share")
            .getter(getter(DbIormConfig::share)).setter(setter(Builder::share))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("share").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD,
            FLASH_CACHE_LIMIT_FIELD, SHARE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbName;

    private final String flashCacheLimit;

    private final Integer share;

    private DbIormConfig(BuilderImpl builder) {
        this.dbName = builder.dbName;
        this.flashCacheLimit = builder.flashCacheLimit;
        this.share = builder.share;
    }

    /**
     * <p>
     * The database name. For the default DbPlan, the dbName is <code>default</code>.
     * </p>
     * 
     * @return The database name. For the default DbPlan, the dbName is <code>default</code>.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The flash cache limit for this database. This value is internally configured based on the share value assigned to
     * the database.
     * </p>
     * 
     * @return The flash cache limit for this database. This value is internally configured based on the share value
     *         assigned to the database.
     */
    public final String flashCacheLimit() {
        return flashCacheLimit;
    }

    /**
     * <p>
     * The relative priority of this database.
     * </p>
     * 
     * @return The relative priority of this database.
     */
    public final Integer share() {
        return share;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(flashCacheLimit());
        hashCode = 31 * hashCode + Objects.hashCode(share());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbIormConfig)) {
            return false;
        }
        DbIormConfig other = (DbIormConfig) obj;
        return Objects.equals(dbName(), other.dbName()) && Objects.equals(flashCacheLimit(), other.flashCacheLimit())
                && Objects.equals(share(), other.share());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DbIormConfig").add("DbName", dbName()).add("FlashCacheLimit", flashCacheLimit())
                .add("Share", share()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "flashCacheLimit":
            return Optional.ofNullable(clazz.cast(flashCacheLimit()));
        case "share":
            return Optional.ofNullable(clazz.cast(share()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbName", DB_NAME_FIELD);
        map.put("flashCacheLimit", FLASH_CACHE_LIMIT_FIELD);
        map.put("share", SHARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbIormConfig, T> g) {
        return obj -> g.apply((DbIormConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DbIormConfig> {
        /**
         * <p>
         * The database name. For the default DbPlan, the dbName is <code>default</code>.
         * </p>
         * 
         * @param dbName
         *        The database name. For the default DbPlan, the dbName is <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The flash cache limit for this database. This value is internally configured based on the share value
         * assigned to the database.
         * </p>
         * 
         * @param flashCacheLimit
         *        The flash cache limit for this database. This value is internally configured based on the share value
         *        assigned to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flashCacheLimit(String flashCacheLimit);

        /**
         * <p>
         * The relative priority of this database.
         * </p>
         * 
         * @param share
         *        The relative priority of this database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder share(Integer share);
    }

    static final class BuilderImpl implements Builder {
        private String dbName;

        private String flashCacheLimit;

        private Integer share;

        private BuilderImpl() {
        }

        private BuilderImpl(DbIormConfig model) {
            dbName(model.dbName);
            flashCacheLimit(model.flashCacheLimit);
            share(model.share);
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getFlashCacheLimit() {
            return flashCacheLimit;
        }

        public final void setFlashCacheLimit(String flashCacheLimit) {
            this.flashCacheLimit = flashCacheLimit;
        }

        @Override
        public final Builder flashCacheLimit(String flashCacheLimit) {
            this.flashCacheLimit = flashCacheLimit;
            return this;
        }

        public final Integer getShare() {
            return share;
        }

        public final void setShare(Integer share) {
            this.share = share;
        }

        @Override
        public final Builder share(Integer share) {
            this.share = share;
            return this;
        }

        @Override
        public DbIormConfig build() {
            return new DbIormConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
