/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.odb.internal.OdbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.odb.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationRequest;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationResponse;
import software.amazon.awssdk.services.odb.model.AccessDeniedException;
import software.amazon.awssdk.services.odb.model.ConflictException;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesResponse;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetDbNodeRequest;
import software.amazon.awssdk.services.odb.model.GetDbNodeResponse;
import software.amazon.awssdk.services.odb.model.GetDbServerRequest;
import software.amazon.awssdk.services.odb.model.GetDbServerResponse;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusRequest;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusResponse;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.InitializeServiceRequest;
import software.amazon.awssdk.services.odb.model.InitializeServiceResponse;
import software.amazon.awssdk.services.odb.model.InternalServerException;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListDbNodesRequest;
import software.amazon.awssdk.services.odb.model.ListDbNodesResponse;
import software.amazon.awssdk.services.odb.model.ListDbServersRequest;
import software.amazon.awssdk.services.odb.model.ListDbServersResponse;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse;
import software.amazon.awssdk.services.odb.model.ListGiVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListGiVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.odb.model.OdbException;
import software.amazon.awssdk.services.odb.model.RebootDbNodeRequest;
import software.amazon.awssdk.services.odb.model.RebootDbNodeResponse;
import software.amazon.awssdk.services.odb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.odb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.odb.model.StartDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StartDbNodeResponse;
import software.amazon.awssdk.services.odb.model.StopDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StopDbNodeResponse;
import software.amazon.awssdk.services.odb.model.TagResourceRequest;
import software.amazon.awssdk.services.odb.model.TagResourceResponse;
import software.amazon.awssdk.services.odb.model.ThrottlingException;
import software.amazon.awssdk.services.odb.model.UntagResourceRequest;
import software.amazon.awssdk.services.odb.model.UntagResourceResponse;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.ValidationException;
import software.amazon.awssdk.services.odb.transform.AcceptMarketplaceRegistrationRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateCloudAutonomousVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateCloudVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteCloudAutonomousVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteCloudVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudAutonomousVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudExadataInfrastructureUnallocatedResourcesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetDbServerRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetOciOnboardingStatusRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.InitializeServiceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListAutonomousVirtualMachinesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListCloudAutonomousVmClustersRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListCloudExadataInfrastructuresRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListCloudVmClustersRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListDbNodesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListDbServersRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListDbSystemShapesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListGiVersionsRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListOdbNetworksRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListOdbPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListSystemVersionsRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.RebootDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.StartDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.StopDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UpdateCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UpdateOdbNetworkRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link OdbClient}.
 *
 * @see OdbClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOdbClient implements OdbClient {
    private static final Logger log = Logger.loggerFor(DefaultOdbClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOdbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "odb" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Registers the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle
     * Database@Amazon Web Services subscription.
     * </p>
     *
     * @param acceptMarketplaceRegistrationRequest
     * @return Result of the AcceptMarketplaceRegistration operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.AcceptMarketplaceRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AcceptMarketplaceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptMarketplaceRegistrationResponse acceptMarketplaceRegistration(
            AcceptMarketplaceRegistrationRequest acceptMarketplaceRegistrationRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptMarketplaceRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptMarketplaceRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptMarketplaceRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptMarketplaceRegistrationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptMarketplaceRegistration");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptMarketplaceRegistrationRequest, AcceptMarketplaceRegistrationResponse>()
                            .withOperationName("AcceptMarketplaceRegistration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptMarketplaceRegistrationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptMarketplaceRegistrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudAutonomousVmClusterRequest
     * @return Result of the CreateCloudAutonomousVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudAutonomousVmClusterResponse createCloudAutonomousVmCluster(
            CreateCloudAutonomousVmClusterRequest createCloudAutonomousVmClusterRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCloudAutonomousVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCloudAutonomousVmClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudAutonomousVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudAutonomousVmClusterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudAutonomousVmCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCloudAutonomousVmClusterRequest, CreateCloudAutonomousVmClusterResponse>()
                            .withOperationName("CreateCloudAutonomousVmCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCloudAutonomousVmClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCloudAutonomousVmClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Exadata infrastructure.
     * </p>
     *
     * @param createCloudExadataInfrastructureRequest
     * @return Result of the CreateCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudExadataInfrastructureResponse createCloudExadataInfrastructure(
            CreateCloudExadataInfrastructureRequest createCloudExadataInfrastructureRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCloudExadataInfrastructureResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCloudExadataInfrastructureResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudExadataInfrastructure");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCloudExadataInfrastructureRequest, CreateCloudExadataInfrastructureResponse>()
                            .withOperationName("CreateCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCloudExadataInfrastructureRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCloudExadataInfrastructureRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VM cluster on the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudVmClusterRequest
     * @return Result of the CreateCloudVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCloudVmClusterResponse createCloudVmCluster(CreateCloudVmClusterRequest createCloudVmClusterRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCloudVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCloudVmClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCloudVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudVmCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateCloudVmClusterRequest, CreateCloudVmClusterResponse>()
                    .withOperationName("CreateCloudVmCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCloudVmClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCloudVmClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an ODB network.
     * </p>
     *
     * @param createOdbNetworkRequest
     * @return Result of the CreateOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateOdbNetworkResponse createOdbNetwork(CreateOdbNetworkRequest createOdbNetworkRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOdbNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOdbNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOdbNetwork");

            return clientHandler.execute(new ClientExecutionParams<CreateOdbNetworkRequest, CreateOdbNetworkResponse>()
                    .withOperationName("CreateOdbNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOdbNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOdbNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a peering connection between an ODB network and either another ODB network or a customer-owned VPC.
     * </p>
     * <p>
     * A peering connection enables private connectivity between the networks for application-tier communication.
     * </p>
     *
     * @param createOdbPeeringConnectionRequest
     * @return Result of the CreateOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOdbPeeringConnectionResponse createOdbPeeringConnection(
            CreateOdbPeeringConnectionRequest createOdbPeeringConnectionRequest) throws ThrottlingException, ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateOdbPeeringConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOdbPeeringConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOdbPeeringConnectionRequest, CreateOdbPeeringConnectionResponse>()
                            .withOperationName("CreateOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createOdbPeeringConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateOdbPeeringConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Autonomous VM cluster.
     * </p>
     *
     * @param deleteCloudAutonomousVmClusterRequest
     * @return Result of the DeleteCloudAutonomousVmCluster operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudAutonomousVmClusterResponse deleteCloudAutonomousVmCluster(
            DeleteCloudAutonomousVmClusterRequest deleteCloudAutonomousVmClusterRequest) throws ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCloudAutonomousVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCloudAutonomousVmClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudAutonomousVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudAutonomousVmClusterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudAutonomousVmCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudAutonomousVmClusterRequest, DeleteCloudAutonomousVmClusterResponse>()
                            .withOperationName("DeleteCloudAutonomousVmCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCloudAutonomousVmClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCloudAutonomousVmClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM
     * clusters that are hosted on this Exadata infrastructure.
     * </p>
     *
     * @param deleteCloudExadataInfrastructureRequest
     * @return Result of the DeleteCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudExadataInfrastructureResponse deleteCloudExadataInfrastructure(
            DeleteCloudExadataInfrastructureRequest deleteCloudExadataInfrastructureRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCloudExadataInfrastructureResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCloudExadataInfrastructureResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudExadataInfrastructure");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudExadataInfrastructureRequest, DeleteCloudExadataInfrastructureResponse>()
                            .withOperationName("DeleteCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCloudExadataInfrastructureRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCloudExadataInfrastructureRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VM cluster.
     * </p>
     *
     * @param deleteCloudVmClusterRequest
     * @return Result of the DeleteCloudVmCluster operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCloudVmClusterResponse deleteCloudVmCluster(DeleteCloudVmClusterRequest deleteCloudVmClusterRequest)
            throws ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCloudVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCloudVmClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCloudVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudVmCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteCloudVmClusterRequest, DeleteCloudVmClusterResponse>()
                    .withOperationName("DeleteCloudVmCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCloudVmClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCloudVmClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified ODB network.
     * </p>
     *
     * @param deleteOdbNetworkRequest
     * @return Result of the DeleteOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteOdbNetworkResponse deleteOdbNetwork(DeleteOdbNetworkRequest deleteOdbNetworkRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOdbNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOdbNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOdbNetwork");

            return clientHandler.execute(new ClientExecutionParams<DeleteOdbNetworkRequest, DeleteOdbNetworkResponse>()
                    .withOperationName("DeleteOdbNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOdbNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOdbNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an ODB peering connection.
     * </p>
     * <p>
     * When you delete an ODB peering connection, the underlying VPC peering connection is also deleted.
     * </p>
     *
     * @param deleteOdbPeeringConnectionRequest
     * @return Result of the DeleteOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOdbPeeringConnectionResponse deleteOdbPeeringConnection(
            DeleteOdbPeeringConnectionRequest deleteOdbPeeringConnectionRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOdbPeeringConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOdbPeeringConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOdbPeeringConnectionRequest, DeleteOdbPeeringConnectionResponse>()
                            .withOperationName("DeleteOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteOdbPeeringConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOdbPeeringConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific Autonomous VM cluster.
     * </p>
     *
     * @param getCloudAutonomousVmClusterRequest
     * @return Result of the GetCloudAutonomousVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudAutonomousVmClusterResponse getCloudAutonomousVmCluster(
            GetCloudAutonomousVmClusterRequest getCloudAutonomousVmClusterRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudAutonomousVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCloudAutonomousVmClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudAutonomousVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudAutonomousVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudAutonomousVmCluster");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudAutonomousVmClusterRequest, GetCloudAutonomousVmClusterResponse>()
                            .withOperationName("GetCloudAutonomousVmCluster").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCloudAutonomousVmClusterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCloudAutonomousVmClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified Exadata infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureRequest
     * @return Result of the GetCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudExadataInfrastructureResponse getCloudExadataInfrastructure(
            GetCloudExadataInfrastructureRequest getCloudExadataInfrastructureRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudExadataInfrastructureResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCloudExadataInfrastructureResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudExadataInfrastructure");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudExadataInfrastructureRequest, GetCloudExadataInfrastructureResponse>()
                            .withOperationName("GetCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCloudExadataInfrastructureRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCloudExadataInfrastructureRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about unallocated resources in a specified Cloud Exadata Infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureUnallocatedResourcesRequest
     * @return Result of the GetCloudExadataInfrastructureUnallocatedResources operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudExadataInfrastructureUnallocatedResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructureUnallocatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudExadataInfrastructureUnallocatedResourcesResponse getCloudExadataInfrastructureUnallocatedResources(
            GetCloudExadataInfrastructureUnallocatedResourcesRequest getCloudExadataInfrastructureUnallocatedResourcesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudExadataInfrastructureUnallocatedResourcesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetCloudExadataInfrastructureUnallocatedResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getCloudExadataInfrastructureUnallocatedResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudExadataInfrastructureUnallocatedResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudExadataInfrastructureUnallocatedResources");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudExadataInfrastructureUnallocatedResourcesRequest, GetCloudExadataInfrastructureUnallocatedResourcesResponse>()
                            .withOperationName("GetCloudExadataInfrastructureUnallocatedResources")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(getCloudExadataInfrastructureUnallocatedResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new GetCloudExadataInfrastructureUnallocatedResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified VM cluster.
     * </p>
     *
     * @param getCloudVmClusterRequest
     * @return Result of the GetCloudVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCloudVmClusterResponse getCloudVmCluster(GetCloudVmClusterRequest getCloudVmClusterRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCloudVmClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudVmCluster");

            return clientHandler.execute(new ClientExecutionParams<GetCloudVmClusterRequest, GetCloudVmClusterResponse>()
                    .withOperationName("GetCloudVmCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCloudVmClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCloudVmClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified DB node.
     * </p>
     *
     * @param getDbNodeRequest
     * @return Result of the GetDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDbNodeResponse getDbNode(GetDbNodeRequest getDbNodeRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDbNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDbNode");

            return clientHandler.execute(new ClientExecutionParams<GetDbNodeRequest, GetDbNodeResponse>()
                    .withOperationName("GetDbNode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getDbNodeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDbNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified database server.
     * </p>
     *
     * @param getDbServerRequest
     * @return Result of the GetDbServer operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetDbServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDbServerResponse getDbServer(GetDbServerRequest getDbServerRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDbServerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDbServerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDbServerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDbServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDbServer");

            return clientHandler.execute(new ClientExecutionParams<GetDbServerRequest, GetDbServerResponse>()
                    .withOperationName("GetDbServer").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getDbServerRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDbServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the tenancy activation link and onboarding status for your Amazon Web Services account.
     * </p>
     *
     * @param getOciOnboardingStatusRequest
     * @return Result of the GetOciOnboardingStatus operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOciOnboardingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOciOnboardingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetOciOnboardingStatusResponse getOciOnboardingStatus(GetOciOnboardingStatusRequest getOciOnboardingStatusRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOciOnboardingStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetOciOnboardingStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOciOnboardingStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOciOnboardingStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOciOnboardingStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOciOnboardingStatusRequest, GetOciOnboardingStatusResponse>()
                            .withOperationName("GetOciOnboardingStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getOciOnboardingStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOciOnboardingStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified ODB network.
     * </p>
     *
     * @param getOdbNetworkRequest
     * @return Result of the GetOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOdbNetworkResponse getOdbNetwork(GetOdbNetworkRequest getOdbNetworkRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOdbNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOdbNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOdbNetwork");

            return clientHandler.execute(new ClientExecutionParams<GetOdbNetworkRequest, GetOdbNetworkResponse>()
                    .withOperationName("GetOdbNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getOdbNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOdbNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an ODB peering connection.
     * </p>
     *
     * @param getOdbPeeringConnectionRequest
     * @return Result of the GetOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetOdbPeeringConnectionResponse getOdbPeeringConnection(GetOdbPeeringConnectionRequest getOdbPeeringConnectionRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetOdbPeeringConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOdbPeeringConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOdbPeeringConnectionRequest, GetOdbPeeringConnectionResponse>()
                            .withOperationName("GetOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getOdbPeeringConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOdbPeeringConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initializes the ODB service for the first time in an account.
     * </p>
     *
     * @param initializeServiceRequest
     * @return Result of the InitializeService operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public InitializeServiceResponse initializeService(InitializeServiceRequest initializeServiceRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InitializeServiceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InitializeServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(initializeServiceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, initializeServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InitializeService");

            return clientHandler.execute(new ClientExecutionParams<InitializeServiceRequest, InitializeServiceResponse>()
                    .withOperationName("InitializeService").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(initializeServiceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new InitializeServiceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Autonomous VMs in an Autonomous VM cluster.
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     * @return Result of the ListAutonomousVirtualMachines operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAutonomousVirtualMachinesResponse listAutonomousVirtualMachines(
            ListAutonomousVirtualMachinesRequest listAutonomousVirtualMachinesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAutonomousVirtualMachinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAutonomousVirtualMachinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAutonomousVirtualMachinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAutonomousVirtualMachinesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAutonomousVirtualMachines");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAutonomousVirtualMachinesRequest, ListAutonomousVirtualMachinesResponse>()
                            .withOperationName("ListAutonomousVirtualMachines").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAutonomousVirtualMachinesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAutonomousVirtualMachinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     * @return Result of the ListCloudAutonomousVmClusters operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudAutonomousVmClustersResponse listCloudAutonomousVmClusters(
            ListCloudAutonomousVmClustersRequest listCloudAutonomousVmClustersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCloudAutonomousVmClustersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCloudAutonomousVmClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudAutonomousVmClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudAutonomousVmClustersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudAutonomousVmClusters");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCloudAutonomousVmClustersRequest, ListCloudAutonomousVmClustersResponse>()
                            .withOperationName("ListCloudAutonomousVmClusters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCloudAutonomousVmClustersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCloudAutonomousVmClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the Exadata infrastructures owned by your Amazon Web Services account.
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     * @return Result of the ListCloudExadataInfrastructures operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudExadataInfrastructuresResponse listCloudExadataInfrastructures(
            ListCloudExadataInfrastructuresRequest listCloudExadataInfrastructuresRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCloudExadataInfrastructuresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCloudExadataInfrastructuresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudExadataInfrastructuresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudExadataInfrastructuresRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudExadataInfrastructures");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse>()
                            .withOperationName("ListCloudExadataInfrastructures").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCloudExadataInfrastructuresRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCloudExadataInfrastructuresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the VM clusters owned by your Amazon Web Services account or only the ones on the
     * specified Exadata infrastructure.
     * </p>
     *
     * @param listCloudVmClustersRequest
     * @return Result of the ListCloudVmClusters operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCloudVmClustersResponse listCloudVmClusters(ListCloudVmClustersRequest listCloudVmClustersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCloudVmClustersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCloudVmClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudVmClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCloudVmClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudVmClusters");

            return clientHandler.execute(new ClientExecutionParams<ListCloudVmClustersRequest, ListCloudVmClustersResponse>()
                    .withOperationName("ListCloudVmClusters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCloudVmClustersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCloudVmClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the DB nodes for the specified VM cluster.
     * </p>
     *
     * @param listDbNodesRequest
     * @return Result of the ListDbNodes operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDbNodesResponse listDbNodes(ListDbNodesRequest listDbNodesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDbNodesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDbNodesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDbNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDbNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDbNodes");

            return clientHandler.execute(new ClientExecutionParams<ListDbNodesRequest, ListDbNodesResponse>()
                    .withOperationName("ListDbNodes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listDbNodesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDbNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the database servers that belong to the specified Exadata infrastructure.
     * </p>
     *
     * @param listDbServersRequest
     * @return Result of the ListDbServers operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDbServersResponse listDbServers(ListDbServersRequest listDbServersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDbServersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDbServersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDbServersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDbServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDbServers");

            return clientHandler.execute(new ClientExecutionParams<ListDbServersRequest, ListDbServersResponse>()
                    .withOperationName("ListDbServers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDbServersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDbServersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the shapes that are available for an Exadata infrastructure.
     * </p>
     *
     * @param listDbSystemShapesRequest
     * @return Result of the ListDbSystemShapes operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDbSystemShapesResponse listDbSystemShapes(ListDbSystemShapesRequest listDbSystemShapesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDbSystemShapesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDbSystemShapesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDbSystemShapesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDbSystemShapesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDbSystemShapes");

            return clientHandler.execute(new ClientExecutionParams<ListDbSystemShapesRequest, ListDbSystemShapesResponse>()
                    .withOperationName("ListDbSystemShapes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDbSystemShapesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDbSystemShapesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster
     * for the specified shape.
     * </p>
     *
     * @param listGiVersionsRequest
     * @return Result of the ListGiVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGiVersionsResponse listGiVersions(ListGiVersionsRequest listGiVersionsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGiVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGiVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGiVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGiVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGiVersions");

            return clientHandler.execute(new ClientExecutionParams<ListGiVersionsRequest, ListGiVersionsResponse>()
                    .withOperationName("ListGiVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGiVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGiVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the ODB networks owned by your Amazon Web Services account.
     * </p>
     *
     * @param listOdbNetworksRequest
     * @return Result of the ListOdbNetworks operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOdbNetworksResponse listOdbNetworks(ListOdbNetworksRequest listOdbNetworksRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOdbNetworksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOdbNetworksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOdbNetworksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOdbNetworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOdbNetworks");

            return clientHandler.execute(new ClientExecutionParams<ListOdbNetworksRequest, ListOdbNetworksResponse>()
                    .withOperationName("ListOdbNetworks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOdbNetworksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOdbNetworksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all ODB peering connections or those associated with a specific ODB network.
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     * @return Result of the ListOdbPeeringConnections operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListOdbPeeringConnectionsResponse listOdbPeeringConnections(
            ListOdbPeeringConnectionsRequest listOdbPeeringConnectionsRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOdbPeeringConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOdbPeeringConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOdbPeeringConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOdbPeeringConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOdbPeeringConnections");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOdbPeeringConnectionsRequest, ListOdbPeeringConnectionsResponse>()
                            .withOperationName("ListOdbPeeringConnections").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listOdbPeeringConnectionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOdbPeeringConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the system versions that are available for a VM cluster for the specified
     * <code>giVersion</code> and <code>shape</code>.
     * </p>
     *
     * @param listSystemVersionsRequest
     * @return Result of the ListSystemVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSystemVersionsResponse listSystemVersions(ListSystemVersionsRequest listSystemVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSystemVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSystemVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSystemVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSystemVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSystemVersions");

            return clientHandler.execute(new ClientExecutionParams<ListSystemVersionsRequest, ListSystemVersionsResponse>()
                    .withOperationName("ListSystemVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSystemVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSystemVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the tags applied to this resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reboots the specified DB node in a VM cluster.
     * </p>
     *
     * @param rebootDbNodeRequest
     * @return Result of the RebootDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.RebootDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/RebootDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RebootDbNodeResponse rebootDbNode(RebootDbNodeRequest rebootDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebootDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RebootDbNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDbNode");

            return clientHandler.execute(new ClientExecutionParams<RebootDbNodeRequest, RebootDbNodeResponse>()
                    .withOperationName("RebootDbNode").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootDbNodeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootDbNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the specified DB node in a VM cluster.
     * </p>
     *
     * @param startDbNodeRequest
     * @return Result of the StartDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.StartDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StartDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartDbNodeResponse startDbNode(StartDbNodeRequest startDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartDbNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDbNode");

            return clientHandler.execute(new ClientExecutionParams<StartDbNodeRequest, StartDbNodeResponse>()
                    .withOperationName("StartDbNode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startDbNodeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartDbNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the specified DB node in a VM cluster.
     * </p>
     *
     * @param stopDbNodeRequest
     * @return Result of the StopDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.StopDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StopDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopDbNodeResponse stopDbNode(StopDbNodeRequest stopDbNodeRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopDbNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDbNode");

            return clientHandler.execute(new ClientExecutionParams<StopDbNodeRequest, StopDbNodeResponse>()
                    .withOperationName("StopDbNode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(stopDbNodeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopDbNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the properties of an Exadata infrastructure resource.
     * </p>
     *
     * @param updateCloudExadataInfrastructureRequest
     * @return Result of the UpdateCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCloudExadataInfrastructureResponse updateCloudExadataInfrastructure(
            UpdateCloudExadataInfrastructureRequest updateCloudExadataInfrastructureRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCloudExadataInfrastructureResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCloudExadataInfrastructureResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudExadataInfrastructure");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudExadataInfrastructureRequest, UpdateCloudExadataInfrastructureResponse>()
                            .withOperationName("UpdateCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCloudExadataInfrastructureRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCloudExadataInfrastructureRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates properties of a specified ODB network.
     * </p>
     *
     * @param updateOdbNetworkRequest
     * @return Result of the UpdateOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateOdbNetworkResponse updateOdbNetwork(UpdateOdbNetworkRequest updateOdbNetworkRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateOdbNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOdbNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOdbNetwork");

            return clientHandler.execute(new ClientExecutionParams<UpdateOdbNetworkRequest, UpdateOdbNetworkResponse>()
                    .withOperationName("UpdateOdbNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateOdbNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateOdbNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        OdbServiceClientConfigurationBuilder serviceConfigBuilder = new OdbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(OdbException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    @Override
    public final OdbServiceClientConfiguration serviceClientConfiguration() {
        return new OdbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
