/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminAsyncClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.CentralizationRuleSummary;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationResponse;

public class ListCentralizationRulesForOrganizationPublisher
implements SdkPublisher<ListCentralizationRulesForOrganizationResponse> {
    private final ObservabilityAdminAsyncClient client;
    private final ListCentralizationRulesForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCentralizationRulesForOrganizationPublisher(ObservabilityAdminAsyncClient client, ListCentralizationRulesForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCentralizationRulesForOrganizationPublisher(ObservabilityAdminAsyncClient client, ListCentralizationRulesForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCentralizationRulesForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCentralizationRulesForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CentralizationRuleSummary> centralizationRuleSummaries() {
        Function<ListCentralizationRulesForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.centralizationRuleSummaries() != null) {
                return response.centralizationRuleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCentralizationRulesForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCentralizationRulesForOrganizationResponseFetcher
    implements AsyncPageFetcher<ListCentralizationRulesForOrganizationResponse> {
        private ListCentralizationRulesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListCentralizationRulesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCentralizationRulesForOrganizationResponse> nextPage(ListCentralizationRulesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListCentralizationRulesForOrganizationPublisher.this.client.listCentralizationRulesForOrganization(ListCentralizationRulesForOrganizationPublisher.this.firstRequest);
            }
            return ListCentralizationRulesForOrganizationPublisher.this.client.listCentralizationRulesForOrganization((ListCentralizationRulesForOrganizationRequest)((Object)ListCentralizationRulesForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

