/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.CentralizationRuleSummary;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListCentralizationRulesForOrganizationResponse;

public class ListCentralizationRulesForOrganizationIterable
implements SdkIterable<ListCentralizationRulesForOrganizationResponse> {
    private final ObservabilityAdminClient client;
    private final ListCentralizationRulesForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCentralizationRulesForOrganizationIterable(ObservabilityAdminClient client, ListCentralizationRulesForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCentralizationRulesForOrganizationResponseFetcher();
    }

    public Iterator<ListCentralizationRulesForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CentralizationRuleSummary> centralizationRuleSummaries() {
        Function<ListCentralizationRulesForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.centralizationRuleSummaries() != null) {
                return response.centralizationRuleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCentralizationRulesForOrganizationResponseFetcher
    implements SyncPageFetcher<ListCentralizationRulesForOrganizationResponse> {
        private ListCentralizationRulesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListCentralizationRulesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCentralizationRulesForOrganizationResponse nextPage(ListCentralizationRulesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListCentralizationRulesForOrganizationIterable.this.client.listCentralizationRulesForOrganization(ListCentralizationRulesForOrganizationIterable.this.firstRequest);
            }
            return ListCentralizationRulesForOrganizationIterable.this.client.listCentralizationRulesForOrganization((ListCentralizationRulesForOrganizationRequest)((Object)ListCentralizationRulesForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

