/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.RegionsCopier;
import software.amazon.awssdk.services.observabilityadmin.model.SourceLogsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CentralizationRuleSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CentralizationRuleSource> {
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(CentralizationRuleSource.getter(CentralizationRuleSource::regions)).setter(CentralizationRuleSource.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(CentralizationRuleSource.getter(CentralizationRuleSource::scope)).setter(CentralizationRuleSource.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<SourceLogsConfiguration> SOURCE_LOGS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceLogsConfiguration").getter(CentralizationRuleSource.getter(CentralizationRuleSource::sourceLogsConfiguration)).setter(CentralizationRuleSource.setter(Builder::sourceLogsConfiguration)).constructor(SourceLogsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLogsConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_FIELD, SCOPE_FIELD, SOURCE_LOGS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CentralizationRuleSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> regions;
    private final String scope;
    private final SourceLogsConfiguration sourceLogsConfiguration;

    private CentralizationRuleSource(BuilderImpl builder) {
        this.regions = builder.regions;
        this.scope = builder.scope;
        this.sourceLogsConfiguration = builder.sourceLogsConfiguration;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final String scope() {
        return this.scope;
    }

    public final SourceLogsConfiguration sourceLogsConfiguration() {
        return this.sourceLogsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLogsConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CentralizationRuleSource)) {
            return false;
        }
        CentralizationRuleSource other = (CentralizationRuleSource)obj;
        return this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.sourceLogsConfiguration(), other.sourceLogsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CentralizationRuleSource").add("Regions", this.hasRegions() ? this.regions() : null).add("Scope", (Object)this.scope()).add("SourceLogsConfiguration", (Object)this.sourceLogsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "SourceLogsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceLogsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Regions", REGIONS_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("SourceLogsConfiguration", SOURCE_LOGS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CentralizationRuleSource, T> g) {
        return obj -> g.apply((CentralizationRuleSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private String scope;
        private SourceLogsConfiguration sourceLogsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CentralizationRuleSource model) {
            this.regions(model.regions);
            this.scope(model.scope);
            this.sourceLogsConfiguration(model.sourceLogsConfiguration);
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final SourceLogsConfiguration.Builder getSourceLogsConfiguration() {
            return this.sourceLogsConfiguration != null ? this.sourceLogsConfiguration.toBuilder() : null;
        }

        public final void setSourceLogsConfiguration(SourceLogsConfiguration.BuilderImpl sourceLogsConfiguration) {
            this.sourceLogsConfiguration = sourceLogsConfiguration != null ? sourceLogsConfiguration.build() : null;
        }

        @Override
        public final Builder sourceLogsConfiguration(SourceLogsConfiguration sourceLogsConfiguration) {
            this.sourceLogsConfiguration = sourceLogsConfiguration;
            return this;
        }

        public CentralizationRuleSource build() {
            return new CentralizationRuleSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CentralizationRuleSource> {
        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder scope(String var1);

        public Builder sourceLogsConfiguration(SourceLogsConfiguration var1);

        default public Builder sourceLogsConfiguration(Consumer<SourceLogsConfiguration.Builder> sourceLogsConfiguration) {
            return this.sourceLogsConfiguration((SourceLogsConfiguration)((SourceLogsConfiguration.Builder)SourceLogsConfiguration.builder().applyMutation(sourceLogsConfiguration)).build());
        }
    }
}

