/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * You can use Amazon CloudWatch Observability Admin to discover and understand the state of telemetry configuration in
 * CloudWatch for your Amazon Web Services Organization or account. This simplifies the process of auditing your
 * telemetry collection configurations across multiple resource types within your Amazon Web Services Organization or
 * account. By providing a consolidated view, it allows you to easily review and manage telemetry settings, helping you
 * ensure proper monitoring and data collection across your Amazon Web Services environment. For more information, see
 * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/telemetry-config-cloudwatch.html">Auditing
 * CloudWatch telemetry conﬁgurations</a> in the CloudWatch User Guide.
 * </p>
 * <p>
 * For information on the permissions you need to use this API, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/auth-and-access-control-cw.html">Identity and
 * access management for Amazon CloudWatch</a> in the CloudWatch User Guide.
 * </p>
 */
package software.amazon.awssdk.services.observabilityadmin;