/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateTelemetryPipelineConfigurationRequest extends ObservabilityAdminRequest implements
        ToCopyableBuilder<ValidateTelemetryPipelineConfigurationRequest.Builder, ValidateTelemetryPipelineConfigurationRequest> {
    private static final SdkField<TelemetryPipelineConfiguration> CONFIGURATION_FIELD = SdkField
            .<TelemetryPipelineConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(ValidateTelemetryPipelineConfigurationRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(TelemetryPipelineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TelemetryPipelineConfiguration configuration;

    private ValidateTelemetryPipelineConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The pipeline configuration to validate for syntax and compatibility.
     * </p>
     * 
     * @return The pipeline configuration to validate for syntax and compatibility.
     */
    public final TelemetryPipelineConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTelemetryPipelineConfigurationRequest)) {
            return false;
        }
        ValidateTelemetryPipelineConfigurationRequest other = (ValidateTelemetryPipelineConfigurationRequest) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateTelemetryPipelineConfigurationRequest").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidateTelemetryPipelineConfigurationRequest, T> g) {
        return obj -> g.apply((ValidateTelemetryPipelineConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateTelemetryPipelineConfigurationRequest> {
        /**
         * <p>
         * The pipeline configuration to validate for syntax and compatibility.
         * </p>
         * 
         * @param configuration
         *        The pipeline configuration to validate for syntax and compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(TelemetryPipelineConfiguration configuration);

        /**
         * <p>
         * The pipeline configuration to validate for syntax and compatibility.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelemetryPipelineConfiguration.Builder}
         * avoiding the need to create one manually via {@link TelemetryPipelineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryPipelineConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(TelemetryPipelineConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link TelemetryPipelineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(TelemetryPipelineConfiguration)
         */
        default Builder configuration(Consumer<TelemetryPipelineConfiguration.Builder> configuration) {
            return configuration(TelemetryPipelineConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ObservabilityAdminRequest.BuilderImpl implements Builder {
        private TelemetryPipelineConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTelemetryPipelineConfigurationRequest model) {
            super(model);
            configuration(model.configuration);
        }

        public final TelemetryPipelineConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(TelemetryPipelineConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(TelemetryPipelineConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateTelemetryPipelineConfigurationRequest build() {
            return new ValidateTelemetryPipelineConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
