/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from pipeline test operations, including processed records and any errors encountered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineOutput implements SdkPojo, Serializable, ToCopyableBuilder<PipelineOutput.Builder, PipelineOutput> {
    private static final SdkField<Record> RECORD_FIELD = SdkField.<Record> builder(MarshallingType.SDK_POJO).memberName("Record")
            .getter(getter(PipelineOutput::record)).setter(setter(Builder::record)).constructor(Record::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Record").build()).build();

    private static final SdkField<PipelineOutputError> ERROR_FIELD = SdkField
            .<PipelineOutputError> builder(MarshallingType.SDK_POJO).memberName("Error").getter(getter(PipelineOutput::error))
            .setter(setter(Builder::error)).constructor(PipelineOutputError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Record record;

    private final PipelineOutputError error;

    private PipelineOutput(BuilderImpl builder) {
        this.record = builder.record;
        this.error = builder.error;
    }

    /**
     * <p>
     * The processed record output from the pipeline test operation.
     * </p>
     * 
     * @return The processed record output from the pipeline test operation.
     */
    public final Record record() {
        return record;
    }

    /**
     * <p>
     * Any error that occurred during the pipeline test operation for this record.
     * </p>
     * 
     * @return Any error that occurred during the pipeline test operation for this record.
     */
    public final PipelineOutputError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(record());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineOutput)) {
            return false;
        }
        PipelineOutput other = (PipelineOutput) obj;
        return Objects.equals(record(), other.record()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineOutput").add("Record", record()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Record":
            return Optional.ofNullable(clazz.cast(record()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Record", RECORD_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineOutput, T> g) {
        return obj -> g.apply((PipelineOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineOutput> {
        /**
         * <p>
         * The processed record output from the pipeline test operation.
         * </p>
         * 
         * @param record
         *        The processed record output from the pipeline test operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Record record);

        /**
         * <p>
         * The processed record output from the pipeline test operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Record.Builder} avoiding the need to
         * create one manually via {@link Record#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Record.Builder#build()} is called immediately and its result is
         * passed to {@link #record(Record)}.
         * 
         * @param record
         *        a consumer that will call methods on {@link Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #record(Record)
         */
        default Builder record(Consumer<Record.Builder> record) {
            return record(Record.builder().applyMutation(record).build());
        }

        /**
         * <p>
         * Any error that occurred during the pipeline test operation for this record.
         * </p>
         * 
         * @param error
         *        Any error that occurred during the pipeline test operation for this record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(PipelineOutputError error);

        /**
         * <p>
         * Any error that occurred during the pipeline test operation for this record.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineOutputError.Builder} avoiding the
         * need to create one manually via {@link PipelineOutputError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineOutputError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(PipelineOutputError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link PipelineOutputError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(PipelineOutputError)
         */
        default Builder error(Consumer<PipelineOutputError.Builder> error) {
            return error(PipelineOutputError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Record record;

        private PipelineOutputError error;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineOutput model) {
            record(model.record);
            error(model.error);
        }

        public final Record.Builder getRecord() {
            return record != null ? record.toBuilder() : null;
        }

        public final void setRecord(Record.BuilderImpl record) {
            this.record = record != null ? record.build() : null;
        }

        @Override
        public final Builder record(Record record) {
            this.record = record;
            return this;
        }

        public final PipelineOutputError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(PipelineOutputError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(PipelineOutputError error) {
            this.error = error;
            return this;
        }

        @Override
        public PipelineOutput build() {
            return new PipelineOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
