/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetS3TableIntegrationResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<GetS3TableIntegrationResponse.Builder, GetS3TableIntegrationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetS3TableIntegrationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(GetS3TableIntegrationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetS3TableIntegrationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(GetS3TableIntegrationResponse::encryption))
            .setter(setter(Builder::encryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final SdkField<String> DESTINATION_TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationTableBucketArn").getter(getter(GetS3TableIntegrationResponse::destinationTableBucketArn))
            .setter(setter(Builder::destinationTableBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableBucketArn").build())
            .build();

    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreatedTimeStamp").getter(getter(GetS3TableIntegrationResponse::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ROLE_ARN_FIELD,
            STATUS_FIELD, ENCRYPTION_FIELD, DESTINATION_TABLE_BUCKET_ARN_FIELD, CREATED_TIME_STAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String roleArn;

    private final String status;

    private final Encryption encryption;

    private final String destinationTableBucketArn;

    private final Long createdTimeStamp;

    private GetS3TableIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.encryption = builder.encryption;
        this.destinationTableBucketArn = builder.destinationTableBucketArn;
        this.createdTimeStamp = builder.createdTimeStamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 Table integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 Table integration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used by the S3 Table integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used by the S3 Table integration.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The current status of the S3 Table integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the S3 Table integration.
     * @see IntegrationStatus
     */
    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the S3 Table integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the S3 Table integration.
     * @see IntegrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The encryption configuration for the S3 Table integration.
     * </p>
     * 
     * @return The encryption configuration for the S3 Table integration.
     */
    public final Encryption encryption() {
        return encryption;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 bucket used as the destination for the table data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 bucket used as the destination for the table data.
     */
    public final String destinationTableBucketArn() {
        return destinationTableBucketArn;
    }

    /**
     * <p>
     * The timestamp when the S3 Table integration was created.
     * </p>
     * 
     * @return The timestamp when the S3 Table integration was created.
     */
    public final Long createdTimeStamp() {
        return createdTimeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetS3TableIntegrationResponse)) {
            return false;
        }
        GetS3TableIntegrationResponse other = (GetS3TableIntegrationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(destinationTableBucketArn(), other.destinationTableBucketArn())
                && Objects.equals(createdTimeStamp(), other.createdTimeStamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetS3TableIntegrationResponse").add("Arn", arn()).add("RoleArn", roleArn())
                .add("Status", statusAsString()).add("Encryption", encryption())
                .add("DestinationTableBucketArn", destinationTableBucketArn()).add("CreatedTimeStamp", createdTimeStamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "DestinationTableBucketArn":
            return Optional.ofNullable(clazz.cast(destinationTableBucketArn()));
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        map.put("DestinationTableBucketArn", DESTINATION_TABLE_BUCKET_ARN_FIELD);
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetS3TableIntegrationResponse, T> g) {
        return obj -> g.apply((GetS3TableIntegrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetS3TableIntegrationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 Table integration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the S3 Table integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used by the S3 Table integration.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used by the S3 Table integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The current status of the S3 Table integration.
         * </p>
         * 
         * @param status
         *        The current status of the S3 Table integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the S3 Table integration.
         * </p>
         * 
         * @param status
         *        The current status of the S3 Table integration.
         * @see IntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntegrationStatus
         */
        Builder status(IntegrationStatus status);

        /**
         * <p>
         * The encryption configuration for the S3 Table integration.
         * </p>
         * 
         * @param encryption
         *        The encryption configuration for the S3 Table integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption configuration for the S3 Table integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Encryption.Builder} avoiding the need to
         * create one manually via {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 bucket used as the destination for the table data.
         * </p>
         * 
         * @param destinationTableBucketArn
         *        The Amazon Resource Name (ARN) of the S3 bucket used as the destination for the table data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableBucketArn(String destinationTableBucketArn);

        /**
         * <p>
         * The timestamp when the S3 Table integration was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The timestamp when the S3 Table integration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Long createdTimeStamp);
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private String arn;

        private String roleArn;

        private String status;

        private Encryption encryption;

        private String destinationTableBucketArn;

        private Long createdTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetS3TableIntegrationResponse model) {
            super(model);
            arn(model.arn);
            roleArn(model.roleArn);
            status(model.status);
            encryption(model.encryption);
            destinationTableBucketArn(model.destinationTableBucketArn);
            createdTimeStamp(model.createdTimeStamp);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getDestinationTableBucketArn() {
            return destinationTableBucketArn;
        }

        public final void setDestinationTableBucketArn(String destinationTableBucketArn) {
            this.destinationTableBucketArn = destinationTableBucketArn;
        }

        @Override
        public final Builder destinationTableBucketArn(String destinationTableBucketArn) {
            this.destinationTableBucketArn = destinationTableBucketArn;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        @Override
        public GetS3TableIntegrationResponse build() {
            return new GetS3TableIntegrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
