/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a field in the request to redact from WAF logs, such as headers, query parameters, or body content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldToMatch implements SdkPojo, Serializable, ToCopyableBuilder<FieldToMatch.Builder, FieldToMatch> {
    private static final SdkField<SingleHeader> SINGLE_HEADER_FIELD = SdkField.<SingleHeader> builder(MarshallingType.SDK_POJO)
            .memberName("SingleHeader").getter(getter(FieldToMatch::singleHeader)).setter(setter(Builder::singleHeader))
            .constructor(SingleHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleHeader").build()).build();

    private static final SdkField<String> URI_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UriPath").getter(getter(FieldToMatch::uriPath)).setter(setter(Builder::uriPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPath").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(FieldToMatch::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Method")
            .getter(getter(FieldToMatch::method)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINGLE_HEADER_FIELD,
            URI_PATH_FIELD, QUERY_STRING_FIELD, METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SingleHeader singleHeader;

    private final String uriPath;

    private final String queryString;

    private final String method;

    private FieldToMatch(BuilderImpl builder) {
        this.singleHeader = builder.singleHeader;
        this.uriPath = builder.uriPath;
        this.queryString = builder.queryString;
        this.method = builder.method;
    }

    /**
     * <p>
     * Redacts a specific header field by name from WAF logs.
     * </p>
     * 
     * @return Redacts a specific header field by name from WAF logs.
     */
    public final SingleHeader singleHeader() {
        return singleHeader;
    }

    /**
     * <p>
     * Redacts the URI path from WAF logs.
     * </p>
     * 
     * @return Redacts the URI path from WAF logs.
     */
    public final String uriPath() {
        return uriPath;
    }

    /**
     * <p>
     * Redacts the entire query string from WAF logs.
     * </p>
     * 
     * @return Redacts the entire query string from WAF logs.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * Redacts the HTTP method from WAF logs.
     * </p>
     * 
     * @return Redacts the HTTP method from WAF logs.
     */
    public final String method() {
        return method;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(singleHeader());
        hashCode = 31 * hashCode + Objects.hashCode(uriPath());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(method());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldToMatch)) {
            return false;
        }
        FieldToMatch other = (FieldToMatch) obj;
        return Objects.equals(singleHeader(), other.singleHeader()) && Objects.equals(uriPath(), other.uriPath())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(method(), other.method());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldToMatch").add("SingleHeader", singleHeader()).add("UriPath", uriPath())
                .add("QueryString", queryString()).add("Method", method()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SingleHeader":
            return Optional.ofNullable(clazz.cast(singleHeader()));
        case "UriPath":
            return Optional.ofNullable(clazz.cast(uriPath()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "Method":
            return Optional.ofNullable(clazz.cast(method()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SingleHeader", SINGLE_HEADER_FIELD);
        map.put("UriPath", URI_PATH_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("Method", METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldToMatch, T> g) {
        return obj -> g.apply((FieldToMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldToMatch> {
        /**
         * <p>
         * Redacts a specific header field by name from WAF logs.
         * </p>
         * 
         * @param singleHeader
         *        Redacts a specific header field by name from WAF logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleHeader(SingleHeader singleHeader);

        /**
         * <p>
         * Redacts a specific header field by name from WAF logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleHeader.Builder} avoiding the need
         * to create one manually via {@link SingleHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #singleHeader(SingleHeader)}.
         * 
         * @param singleHeader
         *        a consumer that will call methods on {@link SingleHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleHeader(SingleHeader)
         */
        default Builder singleHeader(Consumer<SingleHeader.Builder> singleHeader) {
            return singleHeader(SingleHeader.builder().applyMutation(singleHeader).build());
        }

        /**
         * <p>
         * Redacts the URI path from WAF logs.
         * </p>
         * 
         * @param uriPath
         *        Redacts the URI path from WAF logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uriPath(String uriPath);

        /**
         * <p>
         * Redacts the entire query string from WAF logs.
         * </p>
         * 
         * @param queryString
         *        Redacts the entire query string from WAF logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * Redacts the HTTP method from WAF logs.
         * </p>
         * 
         * @param method
         *        Redacts the HTTP method from WAF logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(String method);
    }

    static final class BuilderImpl implements Builder {
        private SingleHeader singleHeader;

        private String uriPath;

        private String queryString;

        private String method;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldToMatch model) {
            singleHeader(model.singleHeader);
            uriPath(model.uriPath);
            queryString(model.queryString);
            method(model.method);
        }

        public final SingleHeader.Builder getSingleHeader() {
            return singleHeader != null ? singleHeader.toBuilder() : null;
        }

        public final void setSingleHeader(SingleHeader.BuilderImpl singleHeader) {
            this.singleHeader = singleHeader != null ? singleHeader.build() : null;
        }

        @Override
        public final Builder singleHeader(SingleHeader singleHeader) {
            this.singleHeader = singleHeader;
            return this;
        }

        public final String getUriPath() {
            return uriPath;
        }

        public final void setUriPath(String uriPath) {
            this.uriPath = uriPath;
        }

        @Override
        public final Builder uriPath(String uriPath) {
            this.uriPath = uriPath;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public FieldToMatch build() {
            return new FieldToMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
