/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTelemetryRuleForOrganizationRequest extends ObservabilityAdminRequest implements
        ToCopyableBuilder<CreateTelemetryRuleForOrganizationRequest.Builder, CreateTelemetryRuleForOrganizationRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(CreateTelemetryRuleForOrganizationRequest::ruleName))
            .setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<TelemetryRule> RULE_FIELD = SdkField.<TelemetryRule> builder(MarshallingType.SDK_POJO)
            .memberName("Rule").getter(getter(CreateTelemetryRuleForOrganizationRequest::rule)).setter(setter(Builder::rule))
            .constructor(TelemetryRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateTelemetryRuleForOrganizationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleName;

    private final TelemetryRule rule;

    private final Map<String, String> tags;

    private CreateTelemetryRuleForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.rule = builder.rule;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name for the organization-wide telemetry rule being created.
     * </p>
     * 
     * @return A unique name for the organization-wide telemetry rule being created.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The configuration details for the organization-wide telemetry rule, including the resource type, telemetry type,
     * destination configuration, and selection criteria for which resources the rule applies to across the
     * organization.
     * </p>
     * 
     * @return The configuration details for the organization-wide telemetry rule, including the resource type,
     *         telemetry type, destination configuration, and selection criteria for which resources the rule applies to
     *         across the organization.
     */
    public final TelemetryRule rule() {
        return rule;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs to associate with the organization telemetry rule resource for categorization and management
     * purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pairs to associate with the organization telemetry rule resource for categorization and
     *         management purposes.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTelemetryRuleForOrganizationRequest)) {
            return false;
        }
        CreateTelemetryRuleForOrganizationRequest other = (CreateTelemetryRuleForOrganizationRequest) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(rule(), other.rule())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTelemetryRuleForOrganizationRequest").add("RuleName", ruleName()).add("Rule", rule())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "Rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTelemetryRuleForOrganizationRequest, T> g) {
        return obj -> g.apply((CreateTelemetryRuleForOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTelemetryRuleForOrganizationRequest> {
        /**
         * <p>
         * A unique name for the organization-wide telemetry rule being created.
         * </p>
         * 
         * @param ruleName
         *        A unique name for the organization-wide telemetry rule being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The configuration details for the organization-wide telemetry rule, including the resource type, telemetry
         * type, destination configuration, and selection criteria for which resources the rule applies to across the
         * organization.
         * </p>
         * 
         * @param rule
         *        The configuration details for the organization-wide telemetry rule, including the resource type,
         *        telemetry type, destination configuration, and selection criteria for which resources the rule applies
         *        to across the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(TelemetryRule rule);

        /**
         * <p>
         * The configuration details for the organization-wide telemetry rule, including the resource type, telemetry
         * type, destination configuration, and selection criteria for which resources the rule applies to across the
         * organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelemetryRule.Builder} avoiding the need
         * to create one manually via {@link TelemetryRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryRule.Builder#build()} is called immediately and its
         * result is passed to {@link #rule(TelemetryRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link TelemetryRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(TelemetryRule)
         */
        default Builder rule(Consumer<TelemetryRule.Builder> rule) {
            return rule(TelemetryRule.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * The key-value pairs to associate with the organization telemetry rule resource for categorization and
         * management purposes.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to associate with the organization telemetry rule resource for categorization and
         *        management purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ObservabilityAdminRequest.BuilderImpl implements Builder {
        private String ruleName;

        private TelemetryRule rule;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTelemetryRuleForOrganizationRequest model) {
            super(model);
            ruleName(model.ruleName);
            rule(model.rule);
            tags(model.tags);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final TelemetryRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(TelemetryRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(TelemetryRule rule) {
            this.rule = rule;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTelemetryRuleForOrganizationRequest build() {
            return new CreateTelemetryRuleForOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
