/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration specifying the source of telemetry data to be centralized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CentralizationRuleSource implements SdkPojo, Serializable,
        ToCopyableBuilder<CentralizationRuleSource.Builder, CentralizationRuleSource> {
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(CentralizationRuleSource::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(CentralizationRuleSource::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<SourceLogsConfiguration> SOURCE_LOGS_CONFIGURATION_FIELD = SdkField
            .<SourceLogsConfiguration> builder(MarshallingType.SDK_POJO).memberName("SourceLogsConfiguration")
            .getter(getter(CentralizationRuleSource::sourceLogsConfiguration)).setter(setter(Builder::sourceLogsConfiguration))
            .constructor(SourceLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLogsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONS_FIELD, SCOPE_FIELD,
            SOURCE_LOGS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> regions;

    private final String scope;

    private final SourceLogsConfiguration sourceLogsConfiguration;

    private CentralizationRuleSource(BuilderImpl builder) {
        this.regions = builder.regions;
        this.scope = builder.scope;
        this.sourceLogsConfiguration = builder.sourceLogsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of source regions from which telemetry data should be centralized.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The list of source regions from which telemetry data should be centralized.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The organizational scope from which telemetry data should be centralized, specified using organization id,
     * accounts or organizational unit ids.
     * </p>
     * 
     * @return The organizational scope from which telemetry data should be centralized, specified using organization
     *         id, accounts or organizational unit ids.
     */
    public final String scope() {
        return scope;
    }

    /**
     * <p>
     * Log specific configuration for centralization source log groups.
     * </p>
     * 
     * @return Log specific configuration for centralization source log groups.
     */
    public final SourceLogsConfiguration sourceLogsConfiguration() {
        return sourceLogsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLogsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CentralizationRuleSource)) {
            return false;
        }
        CentralizationRuleSource other = (CentralizationRuleSource) obj;
        return hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(scope(), other.scope())
                && Objects.equals(sourceLogsConfiguration(), other.sourceLogsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CentralizationRuleSource").add("Regions", hasRegions() ? regions() : null).add("Scope", scope())
                .add("SourceLogsConfiguration", sourceLogsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "SourceLogsConfiguration":
            return Optional.ofNullable(clazz.cast(sourceLogsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Regions", REGIONS_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("SourceLogsConfiguration", SOURCE_LOGS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CentralizationRuleSource, T> g) {
        return obj -> g.apply((CentralizationRuleSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CentralizationRuleSource> {
        /**
         * <p>
         * The list of source regions from which telemetry data should be centralized.
         * </p>
         * 
         * @param regions
         *        The list of source regions from which telemetry data should be centralized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The list of source regions from which telemetry data should be centralized.
         * </p>
         * 
         * @param regions
         *        The list of source regions from which telemetry data should be centralized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The organizational scope from which telemetry data should be centralized, specified using organization id,
         * accounts or organizational unit ids.
         * </p>
         * 
         * @param scope
         *        The organizational scope from which telemetry data should be centralized, specified using organization
         *        id, accounts or organizational unit ids.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * Log specific configuration for centralization source log groups.
         * </p>
         * 
         * @param sourceLogsConfiguration
         *        Log specific configuration for centralization source log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLogsConfiguration(SourceLogsConfiguration sourceLogsConfiguration);

        /**
         * <p>
         * Log specific configuration for centralization source log groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceLogsConfiguration.Builder} avoiding
         * the need to create one manually via {@link SourceLogsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceLogsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceLogsConfiguration(SourceLogsConfiguration)}.
         * 
         * @param sourceLogsConfiguration
         *        a consumer that will call methods on {@link SourceLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceLogsConfiguration(SourceLogsConfiguration)
         */
        default Builder sourceLogsConfiguration(Consumer<SourceLogsConfiguration.Builder> sourceLogsConfiguration) {
            return sourceLogsConfiguration(SourceLogsConfiguration.builder().applyMutation(sourceLogsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String scope;

        private SourceLogsConfiguration sourceLogsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CentralizationRuleSource model) {
            regions(model.regions);
            scope(model.scope);
            sourceLogsConfiguration(model.sourceLogsConfiguration);
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final SourceLogsConfiguration.Builder getSourceLogsConfiguration() {
            return sourceLogsConfiguration != null ? sourceLogsConfiguration.toBuilder() : null;
        }

        public final void setSourceLogsConfiguration(SourceLogsConfiguration.BuilderImpl sourceLogsConfiguration) {
            this.sourceLogsConfiguration = sourceLogsConfiguration != null ? sourceLogsConfiguration.build() : null;
        }

        @Override
        public final Builder sourceLogsConfiguration(SourceLogsConfiguration sourceLogsConfiguration) {
            this.sourceLogsConfiguration = sourceLogsConfiguration;
            return this;
        }

        @Override
        public CentralizationRuleSource build() {
            return new CentralizationRuleSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
