/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how telemetry data should be centralized across an Amazon Web Services Organization, including source and
 * destination configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CentralizationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<CentralizationRule.Builder, CentralizationRule> {
    private static final SdkField<CentralizationRuleSource> SOURCE_FIELD = SdkField
            .<CentralizationRuleSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(CentralizationRule::source)).setter(setter(Builder::source))
            .constructor(CentralizationRuleSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<CentralizationRuleDestination> DESTINATION_FIELD = SdkField
            .<CentralizationRuleDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(CentralizationRule::destination)).setter(setter(Builder::destination))
            .constructor(CentralizationRuleDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CentralizationRuleSource source;

    private final CentralizationRuleDestination destination;

    private CentralizationRule(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * Configuration determining the source of the telemetry data to be centralized.
     * </p>
     * 
     * @return Configuration determining the source of the telemetry data to be centralized.
     */
    public final CentralizationRuleSource source() {
        return source;
    }

    /**
     * <p>
     * Configuration determining where the telemetry data should be centralized, backed up, as well as encryption
     * configuration for the primary and backup destinations.
     * </p>
     * 
     * @return Configuration determining where the telemetry data should be centralized, backed up, as well as
     *         encryption configuration for the primary and backup destinations.
     */
    public final CentralizationRuleDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CentralizationRule)) {
            return false;
        }
        CentralizationRule other = (CentralizationRule) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CentralizationRule").add("Source", source()).add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CentralizationRule, T> g) {
        return obj -> g.apply((CentralizationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CentralizationRule> {
        /**
         * <p>
         * Configuration determining the source of the telemetry data to be centralized.
         * </p>
         * 
         * @param source
         *        Configuration determining the source of the telemetry data to be centralized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(CentralizationRuleSource source);

        /**
         * <p>
         * Configuration determining the source of the telemetry data to be centralized.
         * </p>
         * This is a convenience method that creates an instance of the {@link CentralizationRuleSource.Builder}
         * avoiding the need to create one manually via {@link CentralizationRuleSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CentralizationRuleSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(CentralizationRuleSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link CentralizationRuleSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(CentralizationRuleSource)
         */
        default Builder source(Consumer<CentralizationRuleSource.Builder> source) {
            return source(CentralizationRuleSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Configuration determining where the telemetry data should be centralized, backed up, as well as encryption
         * configuration for the primary and backup destinations.
         * </p>
         * 
         * @param destination
         *        Configuration determining where the telemetry data should be centralized, backed up, as well as
         *        encryption configuration for the primary and backup destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(CentralizationRuleDestination destination);

        /**
         * <p>
         * Configuration determining where the telemetry data should be centralized, backed up, as well as encryption
         * configuration for the primary and backup destinations.
         * </p>
         * This is a convenience method that creates an instance of the {@link CentralizationRuleDestination.Builder}
         * avoiding the need to create one manually via {@link CentralizationRuleDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CentralizationRuleDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #destination(CentralizationRuleDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link CentralizationRuleDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(CentralizationRuleDestination)
         */
        default Builder destination(Consumer<CentralizationRuleDestination.Builder> destination) {
            return destination(CentralizationRuleDestination.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CentralizationRuleSource source;

        private CentralizationRuleDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CentralizationRule model) {
            source(model.source);
            destination(model.destination);
        }

        public final CentralizationRuleSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(CentralizationRuleSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(CentralizationRuleSource source) {
            this.source = source;
            return this;
        }

        public final CentralizationRuleDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(CentralizationRuleDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(CentralizationRuleDestination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public CentralizationRule build() {
            return new CentralizationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
