/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryEnrichmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTelemetryEnrichmentResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, StartTelemetryEnrichmentResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StartTelemetryEnrichmentResponse.getter(StartTelemetryEnrichmentResponse::statusAsString)).setter(StartTelemetryEnrichmentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AWS_RESOURCE_EXPLORER_MANAGED_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsResourceExplorerManagedViewArn").getter(StartTelemetryEnrichmentResponse.getter(StartTelemetryEnrichmentResponse::awsResourceExplorerManagedViewArn)).setter(StartTelemetryEnrichmentResponse.setter(Builder::awsResourceExplorerManagedViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsResourceExplorerManagedViewArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, AWS_RESOURCE_EXPLORER_MANAGED_VIEW_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartTelemetryEnrichmentResponse.memberNameToFieldInitializer();
    private final String status;
    private final String awsResourceExplorerManagedViewArn;

    private StartTelemetryEnrichmentResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.awsResourceExplorerManagedViewArn = builder.awsResourceExplorerManagedViewArn;
    }

    public final TelemetryEnrichmentStatus status() {
        return TelemetryEnrichmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String awsResourceExplorerManagedViewArn() {
        return this.awsResourceExplorerManagedViewArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsResourceExplorerManagedViewArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTelemetryEnrichmentResponse)) {
            return false;
        }
        StartTelemetryEnrichmentResponse other = (StartTelemetryEnrichmentResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.awsResourceExplorerManagedViewArn(), other.awsResourceExplorerManagedViewArn());
    }

    public final String toString() {
        return ToString.builder((String)"StartTelemetryEnrichmentResponse").add("Status", (Object)this.statusAsString()).add("AwsResourceExplorerManagedViewArn", (Object)this.awsResourceExplorerManagedViewArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AwsResourceExplorerManagedViewArn": {
                return Optional.ofNullable(clazz.cast(this.awsResourceExplorerManagedViewArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Status", STATUS_FIELD);
        map.put("AwsResourceExplorerManagedViewArn", AWS_RESOURCE_EXPLORER_MANAGED_VIEW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTelemetryEnrichmentResponse, T> g) {
        return obj -> g.apply((StartTelemetryEnrichmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private String status;
        private String awsResourceExplorerManagedViewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTelemetryEnrichmentResponse model) {
            super(model);
            this.status(model.status);
            this.awsResourceExplorerManagedViewArn(model.awsResourceExplorerManagedViewArn);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryEnrichmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAwsResourceExplorerManagedViewArn() {
            return this.awsResourceExplorerManagedViewArn;
        }

        public final void setAwsResourceExplorerManagedViewArn(String awsResourceExplorerManagedViewArn) {
            this.awsResourceExplorerManagedViewArn = awsResourceExplorerManagedViewArn;
        }

        @Override
        public final Builder awsResourceExplorerManagedViewArn(String awsResourceExplorerManagedViewArn) {
            this.awsResourceExplorerManagedViewArn = awsResourceExplorerManagedViewArn;
            return this;
        }

        @Override
        public StartTelemetryEnrichmentResponse build() {
            return new StartTelemetryEnrichmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTelemetryEnrichmentResponse> {
        public Builder status(String var1);

        public Builder status(TelemetryEnrichmentStatus var1);

        public Builder awsResourceExplorerManagedViewArn(String var1);
    }
}

