/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TelemetryType {
    LOGS("Logs"),
    METRICS("Metrics"),
    TRACES("Traces"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TelemetryType> VALUE_MAP;
    private final String value;

    private TelemetryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TelemetryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TelemetryType> knownValues() {
        EnumSet<TelemetryType> knownValues = EnumSet.allOf(TelemetryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TelemetryType.class, TelemetryType::toString);
    }
}

