/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.observabilityadmin.ObservabilityAdminAsyncClient;
import software.amazon.awssdk.services.observabilityadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationRequest;
import software.amazon.awssdk.services.observabilityadmin.model.ListResourceTelemetryForOrganizationResponse;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration;

public class ListResourceTelemetryForOrganizationPublisher
implements SdkPublisher<ListResourceTelemetryForOrganizationResponse> {
    private final ObservabilityAdminAsyncClient client;
    private final ListResourceTelemetryForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceTelemetryForOrganizationPublisher(ObservabilityAdminAsyncClient client, ListResourceTelemetryForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceTelemetryForOrganizationPublisher(ObservabilityAdminAsyncClient client, ListResourceTelemetryForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceTelemetryForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceTelemetryForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TelemetryConfiguration> telemetryConfigurations() {
        Function<ListResourceTelemetryForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.telemetryConfigurations() != null) {
                return response.telemetryConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceTelemetryForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceTelemetryForOrganizationResponseFetcher
    implements AsyncPageFetcher<ListResourceTelemetryForOrganizationResponse> {
        private ListResourceTelemetryForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTelemetryForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceTelemetryForOrganizationResponse> nextPage(ListResourceTelemetryForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTelemetryForOrganizationPublisher.this.client.listResourceTelemetryForOrganization(ListResourceTelemetryForOrganizationPublisher.this.firstRequest);
            }
            return ListResourceTelemetryForOrganizationPublisher.this.client.listResourceTelemetryForOrganization((ListResourceTelemetryForOrganizationRequest)((Object)ListResourceTelemetryForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

