/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.ModelLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelSummary> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(ModelSummary.getter(ModelSummary::modelId)).setter(ModelSummary.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<ModelLifecycle> MODEL_LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelLifecycle").getter(ModelSummary.getter(ModelSummary::modelLifecycle)).setter(ModelSummary.setter(Builder::modelLifecycle)).constructor(ModelLifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelLifecycle").build()}).build();
    private static final SdkField<Integer> MINIMUM_COMPATIBILITY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumCompatibilityVersion").getter(ModelSummary.getter(ModelSummary::minimumCompatibilityVersion)).setter(ModelSummary.setter(Builder::minimumCompatibilityVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCompatibilityVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_LIFECYCLE_FIELD, MINIMUM_COMPATIBILITY_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelId;
    private final ModelLifecycle modelLifecycle;
    private final Integer minimumCompatibilityVersion;

    private ModelSummary(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelLifecycle = builder.modelLifecycle;
        this.minimumCompatibilityVersion = builder.minimumCompatibilityVersion;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final ModelLifecycle modelLifecycle() {
        return this.modelLifecycle;
    }

    public final Integer minimumCompatibilityVersion() {
        return this.minimumCompatibilityVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCompatibilityVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSummary)) {
            return false;
        }
        ModelSummary other = (ModelSummary)obj;
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelLifecycle(), other.modelLifecycle()) && Objects.equals(this.minimumCompatibilityVersion(), other.minimumCompatibilityVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ModelSummary").add("ModelId", (Object)this.modelId()).add("ModelLifecycle", (Object)this.modelLifecycle()).add("MinimumCompatibilityVersion", (Object)this.minimumCompatibilityVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelLifecycle": {
                return Optional.ofNullable(clazz.cast(this.modelLifecycle()));
            }
            case "minimumCompatibilityVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumCompatibilityVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("modelLifecycle", MODEL_LIFECYCLE_FIELD);
        map.put("minimumCompatibilityVersion", MINIMUM_COMPATIBILITY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelSummary, T> g) {
        return obj -> g.apply((ModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelId;
        private ModelLifecycle modelLifecycle;
        private Integer minimumCompatibilityVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSummary model) {
            this.modelId(model.modelId);
            this.modelLifecycle(model.modelLifecycle);
            this.minimumCompatibilityVersion(model.minimumCompatibilityVersion);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final ModelLifecycle.Builder getModelLifecycle() {
            return this.modelLifecycle != null ? this.modelLifecycle.toBuilder() : null;
        }

        public final void setModelLifecycle(ModelLifecycle.BuilderImpl modelLifecycle) {
            this.modelLifecycle = modelLifecycle != null ? modelLifecycle.build() : null;
        }

        @Override
        public final Builder modelLifecycle(ModelLifecycle modelLifecycle) {
            this.modelLifecycle = modelLifecycle;
            return this;
        }

        public final Integer getMinimumCompatibilityVersion() {
            return this.minimumCompatibilityVersion;
        }

        public final void setMinimumCompatibilityVersion(Integer minimumCompatibilityVersion) {
            this.minimumCompatibilityVersion = minimumCompatibilityVersion;
        }

        @Override
        public final Builder minimumCompatibilityVersion(Integer minimumCompatibilityVersion) {
            this.minimumCompatibilityVersion = minimumCompatibilityVersion;
            return this;
        }

        public ModelSummary build() {
            return new ModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelSummary> {
        public Builder modelId(String var1);

        public Builder modelLifecycle(ModelLifecycle var1);

        default public Builder modelLifecycle(Consumer<ModelLifecycle.Builder> modelLifecycle) {
            return this.modelLifecycle((ModelLifecycle)((ModelLifecycle.Builder)ModelLifecycle.builder().applyMutation(modelLifecycle)).build());
        }

        public Builder minimumCompatibilityVersion(Integer var1);
    }
}

