/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InternalServerExceptionReason {
    INVALID_MODEL_GENERATION("InvalidModelGeneration"),
    REQUEST_TOKEN_LIMIT_EXCEEDED("RequestTokenLimitExceeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InternalServerExceptionReason> VALUE_MAP;
    private final String value;

    private InternalServerExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InternalServerExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InternalServerExceptionReason> knownValues() {
        EnumSet<InternalServerExceptionReason> knownValues = EnumSet.allOf(InternalServerExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InternalServerExceptionReason.class, InternalServerExceptionReason::toString);
    }
}

