/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TraceLocationType {
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TraceLocationType> VALUE_MAP;
    private final String value;

    private TraceLocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TraceLocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TraceLocationType> knownValues() {
        EnumSet<TraceLocationType> knownValues = EnumSet.allOf(TraceLocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TraceLocationType.class, TraceLocationType::toString);
    }
}

