/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedNotificationChildEventsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListManagedNotificationChildEventsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedNotificationChildEventsResponse.getter(ListManagedNotificationChildEventsResponse::nextToken)).setter(ListManagedNotificationChildEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ManagedNotificationChildEventOverview>> MANAGED_NOTIFICATION_CHILD_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedNotificationChildEvents").getter(ListManagedNotificationChildEventsResponse.getter(ListManagedNotificationChildEventsResponse::managedNotificationChildEvents)).setter(ListManagedNotificationChildEventsResponse.setter(Builder::managedNotificationChildEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedNotificationChildEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedNotificationChildEventOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MANAGED_NOTIFICATION_CHILD_EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedNotificationChildEventsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ManagedNotificationChildEventOverview> managedNotificationChildEvents;

    private ListManagedNotificationChildEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.managedNotificationChildEvents = builder.managedNotificationChildEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasManagedNotificationChildEvents() {
        return this.managedNotificationChildEvents != null && !(this.managedNotificationChildEvents instanceof SdkAutoConstructList);
    }

    public final List<ManagedNotificationChildEventOverview> managedNotificationChildEvents() {
        return this.managedNotificationChildEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedNotificationChildEvents() ? this.managedNotificationChildEvents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationChildEventsResponse)) {
            return false;
        }
        ListManagedNotificationChildEventsResponse other = (ListManagedNotificationChildEventsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasManagedNotificationChildEvents() == other.hasManagedNotificationChildEvents() && Objects.equals(this.managedNotificationChildEvents(), other.managedNotificationChildEvents());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedNotificationChildEventsResponse").add("NextToken", (Object)this.nextToken()).add("ManagedNotificationChildEvents", this.hasManagedNotificationChildEvents() ? this.managedNotificationChildEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "managedNotificationChildEvents": {
                return Optional.ofNullable(clazz.cast(this.managedNotificationChildEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("managedNotificationChildEvents", MANAGED_NOTIFICATION_CHILD_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationChildEventsResponse, T> g) {
        return obj -> g.apply((ListManagedNotificationChildEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ManagedNotificationChildEventOverview> managedNotificationChildEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationChildEventsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.managedNotificationChildEvents(model.managedNotificationChildEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedNotificationChildEventOverview.Builder> getManagedNotificationChildEvents() {
            List<ManagedNotificationChildEventOverview.Builder> result = ManagedNotificationChildEventsCopier.copyToBuilder(this.managedNotificationChildEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedNotificationChildEvents(Collection<ManagedNotificationChildEventOverview.BuilderImpl> managedNotificationChildEvents) {
            this.managedNotificationChildEvents = ManagedNotificationChildEventsCopier.copyFromBuilder(managedNotificationChildEvents);
        }

        @Override
        public final Builder managedNotificationChildEvents(Collection<ManagedNotificationChildEventOverview> managedNotificationChildEvents) {
            this.managedNotificationChildEvents = ManagedNotificationChildEventsCopier.copy(managedNotificationChildEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationChildEvents(ManagedNotificationChildEventOverview ... managedNotificationChildEvents) {
            this.managedNotificationChildEvents(Arrays.asList(managedNotificationChildEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedNotificationChildEvents(Consumer<ManagedNotificationChildEventOverview.Builder> ... managedNotificationChildEvents) {
            this.managedNotificationChildEvents(Stream.of(managedNotificationChildEvents).map(c -> (ManagedNotificationChildEventOverview)((ManagedNotificationChildEventOverview.Builder)ManagedNotificationChildEventOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListManagedNotificationChildEventsResponse build() {
            return new ListManagedNotificationChildEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedNotificationChildEventsResponse> {
        public Builder nextToken(String var1);

        public Builder managedNotificationChildEvents(Collection<ManagedNotificationChildEventOverview> var1);

        public Builder managedNotificationChildEvents(ManagedNotificationChildEventOverview ... var1);

        public Builder managedNotificationChildEvents(Consumer<ManagedNotificationChildEventOverview.Builder> ... var1);
    }
}

