/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.ChannelsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListChannelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListChannelsResponse.getter(ListChannelsResponse::nextToken)).setter(ListChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channels").getter(ListChannelsResponse.getter(ListChannelsResponse::channels)).setter(ListChannelsResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CHANNELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChannelsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<String> channels;

    private ListChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.channels = builder.channels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channels() {
        return this.channels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsResponse)) {
            return false;
        }
        ListChannelsResponse other = (ListChannelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelsResponse").add("NextToken", (Object)this.nextToken()).add("Channels", this.hasChannels() ? this.channels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("channels", CHANNELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsResponse, T> g) {
        return obj -> g.apply((ListChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.channels(model.channels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        public ListChannelsResponse build() {
            return new ListChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelsResponse> {
        public Builder nextToken(String var1);

        public Builder channels(Collection<String> var1);

        public Builder channels(String ... var1);
    }
}

