/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.notifications.model.NotificationConfigurationStructure;
import software.amazon.awssdk.services.notifications.model.NotificationConfigurationsCopier;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationConfigurationsResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, ListNotificationConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationConfigurationsResponse.getter(ListNotificationConfigurationsResponse::nextToken)).setter(ListNotificationConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<NotificationConfigurationStructure>> NOTIFICATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationConfigurations").getter(ListNotificationConfigurationsResponse.getter(ListNotificationConfigurationsResponse::notificationConfigurations)).setter(ListNotificationConfigurationsResponse.setter(Builder::notificationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationConfigurationStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NOTIFICATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotificationConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<NotificationConfigurationStructure> notificationConfigurations;

    private ListNotificationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notificationConfigurations = builder.notificationConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNotificationConfigurations() {
        return this.notificationConfigurations != null && !(this.notificationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<NotificationConfigurationStructure> notificationConfigurations() {
        return this.notificationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationConfigurations() ? this.notificationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationConfigurationsResponse)) {
            return false;
        }
        ListNotificationConfigurationsResponse other = (ListNotificationConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNotificationConfigurations() == other.hasNotificationConfigurations() && Objects.equals(this.notificationConfigurations(), other.notificationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("NotificationConfigurations", this.hasNotificationConfigurations() ? this.notificationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "notificationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("notificationConfigurations", NOTIFICATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationConfigurationsResponse, T> g) {
        return obj -> g.apply((ListNotificationConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotificationConfigurationStructure> notificationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.notificationConfigurations(model.notificationConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotificationConfigurationStructure.Builder> getNotificationConfigurations() {
            List<NotificationConfigurationStructure.Builder> result = NotificationConfigurationsCopier.copyToBuilder(this.notificationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationConfigurations(Collection<NotificationConfigurationStructure.BuilderImpl> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copyFromBuilder(notificationConfigurations);
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfigurationStructure> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfigurationStructure ... notificationConfigurations) {
            this.notificationConfigurations(Arrays.asList(notificationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(Consumer<NotificationConfigurationStructure.Builder> ... notificationConfigurations) {
            this.notificationConfigurations(Stream.of(notificationConfigurations).map(c -> (NotificationConfigurationStructure)((NotificationConfigurationStructure.Builder)NotificationConfigurationStructure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotificationConfigurationsResponse build() {
            return new ListNotificationConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder notificationConfigurations(Collection<NotificationConfigurationStructure> var1);

        public Builder notificationConfigurations(NotificationConfigurationStructure ... var1);

        public Builder notificationConfigurations(Consumer<NotificationConfigurationStructure.Builder> ... var1);
    }
}

