/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.notifications.model.EventRuleStatusSummary;
import software.amazon.awssdk.services.notifications.model.ManagedRuleArnsCopier;
import software.amazon.awssdk.services.notifications.model.RegionsCopier;
import software.amazon.awssdk.services.notifications.model.StatusSummaryByRegionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventRuleStructure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventRuleStructure> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EventRuleStructure.getter(EventRuleStructure::arn)).setter(EventRuleStructure.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationConfigurationArn").getter(EventRuleStructure.getter(EventRuleStructure::notificationConfigurationArn)).setter(EventRuleStructure.setter(Builder::notificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(EventRuleStructure.getter(EventRuleStructure::creationTime)).setter(EventRuleStructure.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(EventRuleStructure.getter(EventRuleStructure::source)).setter(EventRuleStructure.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(EventRuleStructure.getter(EventRuleStructure::eventType)).setter(EventRuleStructure.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventPattern").getter(EventRuleStructure.getter(EventRuleStructure::eventPattern)).setter(EventRuleStructure.setter(Builder::eventPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPattern").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(EventRuleStructure.getter(EventRuleStructure::regions)).setter(EventRuleStructure.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MANAGED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedRules").getter(EventRuleStructure.getter(EventRuleStructure::managedRules)).setter(EventRuleStructure.setter(Builder::managedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, EventRuleStatusSummary>> STATUS_SUMMARY_BY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusSummaryByRegion").getter(EventRuleStructure.getter(EventRuleStructure::statusSummaryByRegion)).setter(EventRuleStructure.setter(Builder::statusSummaryByRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummaryByRegion").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventRuleStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NOTIFICATION_CONFIGURATION_ARN_FIELD, CREATION_TIME_FIELD, SOURCE_FIELD, EVENT_TYPE_FIELD, EVENT_PATTERN_FIELD, REGIONS_FIELD, MANAGED_RULES_FIELD, STATUS_SUMMARY_BY_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventRuleStructure.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String notificationConfigurationArn;
    private final Instant creationTime;
    private final String source;
    private final String eventType;
    private final String eventPattern;
    private final List<String> regions;
    private final List<String> managedRules;
    private final Map<String, EventRuleStatusSummary> statusSummaryByRegion;

    private EventRuleStructure(BuilderImpl builder) {
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.creationTime = builder.creationTime;
        this.source = builder.source;
        this.eventType = builder.eventType;
        this.eventPattern = builder.eventPattern;
        this.regions = builder.regions;
        this.managedRules = builder.managedRules;
        this.statusSummaryByRegion = builder.statusSummaryByRegion;
    }

    public final String arn() {
        return this.arn;
    }

    public final String notificationConfigurationArn() {
        return this.notificationConfigurationArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String source() {
        return this.source;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final String eventPattern() {
        return this.eventPattern;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final boolean hasManagedRules() {
        return this.managedRules != null && !(this.managedRules instanceof SdkAutoConstructList);
    }

    public final List<String> managedRules() {
        return this.managedRules;
    }

    public final boolean hasStatusSummaryByRegion() {
        return this.statusSummaryByRegion != null && !(this.statusSummaryByRegion instanceof SdkAutoConstructMap);
    }

    public final Map<String, EventRuleStatusSummary> statusSummaryByRegion() {
        return this.statusSummaryByRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedRules() ? this.managedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusSummaryByRegion() ? this.statusSummaryByRegion() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventRuleStructure)) {
            return false;
        }
        EventRuleStructure other = (EventRuleStructure)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.notificationConfigurationArn(), other.notificationConfigurationArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.eventPattern(), other.eventPattern()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && this.hasManagedRules() == other.hasManagedRules() && Objects.equals(this.managedRules(), other.managedRules()) && this.hasStatusSummaryByRegion() == other.hasStatusSummaryByRegion() && Objects.equals(this.statusSummaryByRegion(), other.statusSummaryByRegion());
    }

    public final String toString() {
        return ToString.builder((String)"EventRuleStructure").add("Arn", (Object)this.arn()).add("NotificationConfigurationArn", (Object)this.notificationConfigurationArn()).add("CreationTime", (Object)this.creationTime()).add("Source", (Object)this.source()).add("EventType", (Object)this.eventType()).add("EventPattern", (Object)this.eventPattern()).add("Regions", this.hasRegions() ? this.regions() : null).add("ManagedRules", this.hasManagedRules() ? this.managedRules() : null).add("StatusSummaryByRegion", this.hasStatusSummaryByRegion() ? this.statusSummaryByRegion() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "notificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurationArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "eventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "managedRules": {
                return Optional.ofNullable(clazz.cast(this.managedRules()));
            }
            case "statusSummaryByRegion": {
                return Optional.ofNullable(clazz.cast(this.statusSummaryByRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventPattern", EVENT_PATTERN_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("managedRules", MANAGED_RULES_FIELD);
        map.put("statusSummaryByRegion", STATUS_SUMMARY_BY_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventRuleStructure, T> g) {
        return obj -> g.apply((EventRuleStructure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String notificationConfigurationArn;
        private Instant creationTime;
        private String source;
        private String eventType;
        private String eventPattern;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<String> managedRules = DefaultSdkAutoConstructList.getInstance();
        private Map<String, EventRuleStatusSummary> statusSummaryByRegion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventRuleStructure model) {
            this.arn(model.arn);
            this.notificationConfigurationArn(model.notificationConfigurationArn);
            this.creationTime(model.creationTime);
            this.source(model.source);
            this.eventType(model.eventType);
            this.eventPattern(model.eventPattern);
            this.regions(model.regions);
            this.managedRules(model.managedRules);
            this.statusSummaryByRegion(model.statusSummaryByRegion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final Collection<String> getManagedRules() {
            if (this.managedRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedRules;
        }

        public final void setManagedRules(Collection<String> managedRules) {
            this.managedRules = ManagedRuleArnsCopier.copy(managedRules);
        }

        @Override
        public final Builder managedRules(Collection<String> managedRules) {
            this.managedRules = ManagedRuleArnsCopier.copy(managedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(String ... managedRules) {
            this.managedRules(Arrays.asList(managedRules));
            return this;
        }

        public final Map<String, EventRuleStatusSummary.Builder> getStatusSummaryByRegion() {
            Map<String, EventRuleStatusSummary.Builder> result = StatusSummaryByRegionCopier.copyToBuilder(this.statusSummaryByRegion);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaryByRegion(Map<String, EventRuleStatusSummary.BuilderImpl> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copyFromBuilder(statusSummaryByRegion);
        }

        @Override
        public final Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copy(statusSummaryByRegion);
            return this;
        }

        public EventRuleStructure build() {
            return new EventRuleStructure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventRuleStructure> {
        public Builder arn(String var1);

        public Builder notificationConfigurationArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder source(String var1);

        public Builder eventType(String var1);

        public Builder eventPattern(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder managedRules(Collection<String> var1);

        public Builder managedRules(String ... var1);

        public Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> var1);
    }
}

