/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChannelAssociationSummary;

public class ListManagedNotificationChannelAssociationsIterable
implements SdkIterable<ListManagedNotificationChannelAssociationsResponse> {
    private final NotificationsClient client;
    private final ListManagedNotificationChannelAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedNotificationChannelAssociationsIterable(NotificationsClient client, ListManagedNotificationChannelAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedNotificationChannelAssociationsResponseFetcher();
    }

    public Iterator<ListManagedNotificationChannelAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedNotificationChannelAssociationSummary> channelAssociations() {
        Function<ListManagedNotificationChannelAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelAssociations() != null) {
                return response.channelAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedNotificationChannelAssociationsResponseFetcher
    implements SyncPageFetcher<ListManagedNotificationChannelAssociationsResponse> {
        private ListManagedNotificationChannelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationChannelAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedNotificationChannelAssociationsResponse nextPage(ListManagedNotificationChannelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationChannelAssociationsIterable.this.client.listManagedNotificationChannelAssociations(ListManagedNotificationChannelAssociationsIterable.this.firstRequest);
            }
            return ListManagedNotificationChannelAssociationsIterable.this.client.listManagedNotificationChannelAssociations((ListManagedNotificationChannelAssociationsRequest)((Object)ListManagedNotificationChannelAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

