/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.notifications.model.EventRuleStatusSummary;
import software.amazon.awssdk.services.notifications.model.NotificationsResponse;
import software.amazon.awssdk.services.notifications.model.StatusSummaryByRegionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventRuleResponse
extends NotificationsResponse
implements ToCopyableBuilder<Builder, UpdateEventRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateEventRuleResponse.getter(UpdateEventRuleResponse::arn)).setter(UpdateEventRuleResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("notificationConfigurationArn").getter(UpdateEventRuleResponse.getter(UpdateEventRuleResponse::notificationConfigurationArn)).setter(UpdateEventRuleResponse.setter(Builder::notificationConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn").build()}).build();
    private static final SdkField<Map<String, EventRuleStatusSummary>> STATUS_SUMMARY_BY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusSummaryByRegion").getter(UpdateEventRuleResponse.getter(UpdateEventRuleResponse::statusSummaryByRegion)).setter(UpdateEventRuleResponse.setter(Builder::statusSummaryByRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummaryByRegion").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventRuleStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NOTIFICATION_CONFIGURATION_ARN_FIELD, STATUS_SUMMARY_BY_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
            this.put("statusSummaryByRegion", STATUS_SUMMARY_BY_REGION_FIELD);
        }
    });
    private final String arn;
    private final String notificationConfigurationArn;
    private final Map<String, EventRuleStatusSummary> statusSummaryByRegion;

    private UpdateEventRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.statusSummaryByRegion = builder.statusSummaryByRegion;
    }

    public final String arn() {
        return this.arn;
    }

    public final String notificationConfigurationArn() {
        return this.notificationConfigurationArn;
    }

    public final boolean hasStatusSummaryByRegion() {
        return this.statusSummaryByRegion != null && !(this.statusSummaryByRegion instanceof SdkAutoConstructMap);
    }

    public final Map<String, EventRuleStatusSummary> statusSummaryByRegion() {
        return this.statusSummaryByRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusSummaryByRegion() ? this.statusSummaryByRegion() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventRuleResponse)) {
            return false;
        }
        UpdateEventRuleResponse other = (UpdateEventRuleResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.notificationConfigurationArn(), other.notificationConfigurationArn()) && this.hasStatusSummaryByRegion() == other.hasStatusSummaryByRegion() && Objects.equals(this.statusSummaryByRegion(), other.statusSummaryByRegion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventRuleResponse").add("Arn", (Object)this.arn()).add("NotificationConfigurationArn", (Object)this.notificationConfigurationArn()).add("StatusSummaryByRegion", this.hasStatusSummaryByRegion() ? this.statusSummaryByRegion() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "notificationConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationConfigurationArn()));
            }
            case "statusSummaryByRegion": {
                return Optional.ofNullable(clazz.cast(this.statusSummaryByRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventRuleResponse, T> g) {
        return obj -> g.apply((UpdateEventRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NotificationsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String notificationConfigurationArn;
        private Map<String, EventRuleStatusSummary> statusSummaryByRegion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventRuleResponse model) {
            super(model);
            this.arn(model.arn);
            this.notificationConfigurationArn(model.notificationConfigurationArn);
            this.statusSummaryByRegion(model.statusSummaryByRegion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final Map<String, EventRuleStatusSummary.Builder> getStatusSummaryByRegion() {
            Map<String, EventRuleStatusSummary.Builder> result = StatusSummaryByRegionCopier.copyToBuilder(this.statusSummaryByRegion);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaryByRegion(Map<String, EventRuleStatusSummary.BuilderImpl> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copyFromBuilder(statusSummaryByRegion);
        }

        @Override
        public final Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copy(statusSummaryByRegion);
            return this;
        }

        @Override
        public UpdateEventRuleResponse build() {
            return new UpdateEventRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventRuleResponse> {
        public Builder arn(String var1);

        public Builder notificationConfigurationArn(String var1);

        public Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> var1);
    }
}

