/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioResponse;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.waiters.NimbleWaiter;
import software.amazon.awssdk.services.nimble.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultNimbleWaiter
implements NimbleWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final NimbleClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetLaunchProfileResponse> launchProfileDeletedWaiter;
    private final Waiter<GetLaunchProfileResponse> launchProfileReadyWaiter;
    private final Waiter<GetStreamingImageResponse> streamingImageDeletedWaiter;
    private final Waiter<GetStreamingImageResponse> streamingImageReadyWaiter;
    private final Waiter<GetStreamingSessionResponse> streamingSessionDeletedWaiter;
    private final Waiter<GetStreamingSessionResponse> streamingSessionReadyWaiter;
    private final Waiter<GetStreamingSessionResponse> streamingSessionStoppedWaiter;
    private final Waiter<GetStreamingSessionStreamResponse> streamingSessionStreamReadyWaiter;
    private final Waiter<GetStudioComponentResponse> studioComponentDeletedWaiter;
    private final Waiter<GetStudioComponentResponse> studioComponentReadyWaiter;
    private final Waiter<GetStudioResponse> studioDeletedWaiter;
    private final Waiter<GetStudioResponse> studioReadyWaiter;

    private DefaultNimbleWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (NimbleClient)NimbleClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.launchProfileDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLaunchProfileResponse.class).acceptors(DefaultNimbleWaiter.launchProfileDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.launchProfileDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.launchProfileReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLaunchProfileResponse.class).acceptors(DefaultNimbleWaiter.launchProfileReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.launchProfileReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingImageDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingImageResponse.class).acceptors(DefaultNimbleWaiter.streamingImageDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.streamingImageDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingImageReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingImageResponse.class).acceptors(DefaultNimbleWaiter.streamingImageReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.streamingImageReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingSessionDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingSessionResponse.class).acceptors(DefaultNimbleWaiter.streamingSessionDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.streamingSessionDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingSessionReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingSessionResponse.class).acceptors(DefaultNimbleWaiter.streamingSessionReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.streamingSessionReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingSessionStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingSessionResponse.class).acceptors(DefaultNimbleWaiter.streamingSessionStoppedWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.streamingSessionStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingSessionStreamReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingSessionStreamResponse.class).acceptors(DefaultNimbleWaiter.streamingSessionStreamReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.streamingSessionStreamReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.studioComponentDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStudioComponentResponse.class).acceptors(DefaultNimbleWaiter.studioComponentDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.studioComponentDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.studioComponentReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStudioComponentResponse.class).acceptors(DefaultNimbleWaiter.studioComponentReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.studioComponentReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.studioDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStudioResponse.class).acceptors(DefaultNimbleWaiter.studioDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.studioDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.studioReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStudioResponse.class).acceptors(DefaultNimbleWaiter.studioReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleWaiter.studioReadyWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetLaunchProfileResponse> waitUntilLaunchProfileDeleted(GetLaunchProfileRequest getLaunchProfileRequest) {
        return this.launchProfileDeletedWaiter.run(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)));
    }

    @Override
    public WaiterResponse<GetLaunchProfileResponse> waitUntilLaunchProfileDeleted(GetLaunchProfileRequest getLaunchProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.launchProfileDeletedWaiter.run(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)), DefaultNimbleWaiter.launchProfileDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLaunchProfileResponse> waitUntilLaunchProfileReady(GetLaunchProfileRequest getLaunchProfileRequest) {
        return this.launchProfileReadyWaiter.run(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)));
    }

    @Override
    public WaiterResponse<GetLaunchProfileResponse> waitUntilLaunchProfileReady(GetLaunchProfileRequest getLaunchProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.launchProfileReadyWaiter.run(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)), DefaultNimbleWaiter.launchProfileReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingImageResponse> waitUntilStreamingImageDeleted(GetStreamingImageRequest getStreamingImageRequest) {
        return this.streamingImageDeletedWaiter.run(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingImageResponse> waitUntilStreamingImageDeleted(GetStreamingImageRequest getStreamingImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingImageDeletedWaiter.run(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)), DefaultNimbleWaiter.streamingImageDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingImageResponse> waitUntilStreamingImageReady(GetStreamingImageRequest getStreamingImageRequest) {
        return this.streamingImageReadyWaiter.run(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingImageResponse> waitUntilStreamingImageReady(GetStreamingImageRequest getStreamingImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingImageReadyWaiter.run(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)), DefaultNimbleWaiter.streamingImageReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingSessionResponse> waitUntilStreamingSessionDeleted(GetStreamingSessionRequest getStreamingSessionRequest) {
        return this.streamingSessionDeletedWaiter.run(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingSessionResponse> waitUntilStreamingSessionDeleted(GetStreamingSessionRequest getStreamingSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionDeletedWaiter.run(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)), DefaultNimbleWaiter.streamingSessionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingSessionResponse> waitUntilStreamingSessionReady(GetStreamingSessionRequest getStreamingSessionRequest) {
        return this.streamingSessionReadyWaiter.run(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingSessionResponse> waitUntilStreamingSessionReady(GetStreamingSessionRequest getStreamingSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionReadyWaiter.run(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)), DefaultNimbleWaiter.streamingSessionReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingSessionResponse> waitUntilStreamingSessionStopped(GetStreamingSessionRequest getStreamingSessionRequest) {
        return this.streamingSessionStoppedWaiter.run(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingSessionResponse> waitUntilStreamingSessionStopped(GetStreamingSessionRequest getStreamingSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionStoppedWaiter.run(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)), DefaultNimbleWaiter.streamingSessionStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingSessionStreamResponse> waitUntilStreamingSessionStreamReady(GetStreamingSessionStreamRequest getStreamingSessionStreamRequest) {
        return this.streamingSessionStreamReadyWaiter.run(() -> this.client.getStreamingSessionStream(this.applyWaitersUserAgent(getStreamingSessionStreamRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingSessionStreamResponse> waitUntilStreamingSessionStreamReady(GetStreamingSessionStreamRequest getStreamingSessionStreamRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionStreamReadyWaiter.run(() -> this.client.getStreamingSessionStream(this.applyWaitersUserAgent(getStreamingSessionStreamRequest)), DefaultNimbleWaiter.streamingSessionStreamReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStudioComponentResponse> waitUntilStudioComponentDeleted(GetStudioComponentRequest getStudioComponentRequest) {
        return this.studioComponentDeletedWaiter.run(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)));
    }

    @Override
    public WaiterResponse<GetStudioComponentResponse> waitUntilStudioComponentDeleted(GetStudioComponentRequest getStudioComponentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioComponentDeletedWaiter.run(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)), DefaultNimbleWaiter.studioComponentDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStudioComponentResponse> waitUntilStudioComponentReady(GetStudioComponentRequest getStudioComponentRequest) {
        return this.studioComponentReadyWaiter.run(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)));
    }

    @Override
    public WaiterResponse<GetStudioComponentResponse> waitUntilStudioComponentReady(GetStudioComponentRequest getStudioComponentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioComponentReadyWaiter.run(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)), DefaultNimbleWaiter.studioComponentReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStudioResponse> waitUntilStudioDeleted(GetStudioRequest getStudioRequest) {
        return this.studioDeletedWaiter.run(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)));
    }

    @Override
    public WaiterResponse<GetStudioResponse> waitUntilStudioDeleted(GetStudioRequest getStudioRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioDeletedWaiter.run(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)), DefaultNimbleWaiter.studioDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStudioResponse> waitUntilStudioReady(GetStudioRequest getStudioRequest) {
        return this.studioReadyWaiter.run(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)));
    }

    @Override
    public WaiterResponse<GetStudioResponse> waitUntilStudioReady(GetStudioRequest getStudioRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioReadyWaiter.run(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)), DefaultNimbleWaiter.studioReadyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetLaunchProfileResponse>> launchProfileDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>> result = new ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (launchProfile.state=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLaunchProfileResponse>> launchProfileReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>> result = new ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (launchProfile.state=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (launchProfile.state=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingImageResponse>> streamingImageDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (streamingImage.state=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingImageResponse>> streamingImageReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (streamingImage.state=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (streamingImage.state=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionResponse>> streamingSessionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (session.state=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionResponse>> streamingSessionReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (session.state=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "START_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (session.state=START_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionResponse>> streamingSessionStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "STOPPED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "STOP_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (session.state=STOP_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionStreamResponse>> streamingSessionStreamReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionStreamResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionStreamResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("stream").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("stream").field("state").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (stream.state=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioComponentResponse>> studioComponentDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (studioComponent.state=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioComponentResponse>> studioComponentReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (studioComponent.state=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (studioComponent.state=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioResponse>> studioDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (studio.state=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioResponse>> studioReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (studio.state=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (studio.state=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration launchProfileDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration launchProfileReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingImageDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingImageReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionStreamReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioComponentDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioComponentReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static NimbleWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends NimbleRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NimbleRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements NimbleWaiter.Builder {
        private NimbleClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public NimbleWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public NimbleWaiter.Builder client(NimbleClient client) {
            this.client = client;
            return this;
        }

        @Override
        public NimbleWaiter build() {
            return new DefaultNimbleWaiter(this);
        }
    }
}

