/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.nimble.DefaultNimbleBaseClientBuilder;
import software.amazon.awssdk.services.nimble.DefaultNimbleClient;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.NimbleClientBuilder;
import software.amazon.awssdk.services.nimble.NimbleServiceClientConfiguration;
import software.amazon.awssdk.services.nimble.endpoints.NimbleEndpointProvider;

@SdkInternalApi
final class DefaultNimbleClientBuilder
extends DefaultNimbleBaseClientBuilder<NimbleClientBuilder, NimbleClient>
implements NimbleClientBuilder {
    DefaultNimbleClientBuilder() {
    }

    @Override
    public DefaultNimbleClientBuilder endpointProvider(NimbleEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NimbleClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultNimbleClientBuilder.validateClientOptions(clientConfiguration);
        NimbleServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultNimbleClient client = new DefaultNimbleClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private NimbleServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return NimbleServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

