/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.EC2SubnetIdListCopier;
import software.amazon.awssdk.services.nimble.model.LaunchProfileProtocolVersionListCopier;
import software.amazon.awssdk.services.nimble.model.LaunchProfileStudioComponentIdListCopier;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchProfileRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, CreateLaunchProfileRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::clientToken)).setter(CreateLaunchProfileRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::description)).setter(CreateLaunchProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EC2_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2SubnetIds").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::ec2SubnetIds)).setter(CreateLaunchProfileRequest.setter(Builder::ec2SubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("launchProfileProtocolVersions").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::launchProfileProtocolVersions)).setter(CreateLaunchProfileRequest.setter(Builder::launchProfileProtocolVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::name)).setter(CreateLaunchProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<StreamConfigurationCreate> STREAM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamConfiguration").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::streamConfiguration)).setter(CreateLaunchProfileRequest.setter(Builder::streamConfiguration)).constructor(StreamConfigurationCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamConfiguration").build()}).build();
    private static final SdkField<List<String>> STUDIO_COMPONENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("studioComponentIds").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::studioComponentIds)).setter(CreateLaunchProfileRequest.setter(Builder::studioComponentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::studioId)).setter(CreateLaunchProfileRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLaunchProfileRequest.getter(CreateLaunchProfileRequest::tags)).setter(CreateLaunchProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, EC2_SUBNET_IDS_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD, NAME_FIELD, STREAM_CONFIGURATION_FIELD, STUDIO_COMPONENT_IDS_FIELD, STUDIO_ID_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String description;
    private final List<String> ec2SubnetIds;
    private final List<String> launchProfileProtocolVersions;
    private final String name;
    private final StreamConfigurationCreate streamConfiguration;
    private final List<String> studioComponentIds;
    private final String studioId;
    private final Map<String, String> tags;

    private CreateLaunchProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.ec2SubnetIds = builder.ec2SubnetIds;
        this.launchProfileProtocolVersions = builder.launchProfileProtocolVersions;
        this.name = builder.name;
        this.streamConfiguration = builder.streamConfiguration;
        this.studioComponentIds = builder.studioComponentIds;
        this.studioId = builder.studioId;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEc2SubnetIds() {
        return this.ec2SubnetIds != null && !(this.ec2SubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2SubnetIds() {
        return this.ec2SubnetIds;
    }

    public final boolean hasLaunchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions != null && !(this.launchProfileProtocolVersions instanceof SdkAutoConstructList);
    }

    public final List<String> launchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions;
    }

    public final String name() {
        return this.name;
    }

    public final StreamConfigurationCreate streamConfiguration() {
        return this.streamConfiguration;
    }

    public final boolean hasStudioComponentIds() {
        return this.studioComponentIds != null && !(this.studioComponentIds instanceof SdkAutoConstructList);
    }

    public final List<String> studioComponentIds() {
        return this.studioComponentIds;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SubnetIds() ? this.ec2SubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudioComponentIds() ? this.studioComponentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchProfileRequest)) {
            return false;
        }
        CreateLaunchProfileRequest other = (CreateLaunchProfileRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && this.hasEc2SubnetIds() == other.hasEc2SubnetIds() && Objects.equals(this.ec2SubnetIds(), other.ec2SubnetIds()) && this.hasLaunchProfileProtocolVersions() == other.hasLaunchProfileProtocolVersions() && Objects.equals(this.launchProfileProtocolVersions(), other.launchProfileProtocolVersions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.streamConfiguration(), other.streamConfiguration()) && this.hasStudioComponentIds() == other.hasStudioComponentIds() && Objects.equals(this.studioComponentIds(), other.studioComponentIds()) && Objects.equals(this.studioId(), other.studioId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLaunchProfileRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Ec2SubnetIds", this.hasEc2SubnetIds() ? this.ec2SubnetIds() : null).add("LaunchProfileProtocolVersions", this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("StreamConfiguration", (Object)this.streamConfiguration()).add("StudioComponentIds", this.hasStudioComponentIds() ? this.studioComponentIds() : null).add("StudioId", (Object)this.studioId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ec2SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetIds()));
            }
            case "launchProfileProtocolVersions": {
                return Optional.ofNullable(clazz.cast(this.launchProfileProtocolVersions()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "streamConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamConfiguration()));
            }
            case "studioComponentIds": {
                return Optional.ofNullable(clazz.cast(this.studioComponentIds()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchProfileRequest, T> g) {
        return obj -> g.apply((CreateLaunchProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private List<String> ec2SubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> launchProfileProtocolVersions = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private StreamConfigurationCreate streamConfiguration;
        private List<String> studioComponentIds = DefaultSdkAutoConstructList.getInstance();
        private String studioId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchProfileRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.ec2SubnetIds(model.ec2SubnetIds);
            this.launchProfileProtocolVersions(model.launchProfileProtocolVersions);
            this.name(model.name);
            this.streamConfiguration(model.streamConfiguration);
            this.studioComponentIds(model.studioComponentIds);
            this.studioId(model.studioId);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SubnetIds() {
            if (this.ec2SubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2SubnetIds;
        }

        public final void setEc2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = EC2SubnetIdListCopier.copy(ec2SubnetIds);
        }

        @Override
        public final Builder ec2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = EC2SubnetIdListCopier.copy(ec2SubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SubnetIds(String ... ec2SubnetIds) {
            this.ec2SubnetIds(Arrays.asList(ec2SubnetIds));
            return this;
        }

        public final Collection<String> getLaunchProfileProtocolVersions() {
            if (this.launchProfileProtocolVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchProfileProtocolVersions;
        }

        public final void setLaunchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
        }

        @Override
        public final Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchProfileProtocolVersions(String ... launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions(Arrays.asList(launchProfileProtocolVersions));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamConfigurationCreate.Builder getStreamConfiguration() {
            return this.streamConfiguration != null ? this.streamConfiguration.toBuilder() : null;
        }

        public final void setStreamConfiguration(StreamConfigurationCreate.BuilderImpl streamConfiguration) {
            this.streamConfiguration = streamConfiguration != null ? streamConfiguration.build() : null;
        }

        @Override
        public final Builder streamConfiguration(StreamConfigurationCreate streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        public final Collection<String> getStudioComponentIds() {
            if (this.studioComponentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.studioComponentIds;
        }

        public final void setStudioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
        }

        @Override
        public final Builder studioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studioComponentIds(String ... studioComponentIds) {
            this.studioComponentIds(Arrays.asList(studioComponentIds));
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchProfileRequest build() {
            return new CreateLaunchProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchProfileRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder ec2SubnetIds(Collection<String> var1);

        public Builder ec2SubnetIds(String ... var1);

        public Builder launchProfileProtocolVersions(Collection<String> var1);

        public Builder launchProfileProtocolVersions(String ... var1);

        public Builder name(String var1);

        public Builder streamConfiguration(StreamConfigurationCreate var1);

        default public Builder streamConfiguration(Consumer<StreamConfigurationCreate.Builder> streamConfiguration) {
            return this.streamConfiguration((StreamConfigurationCreate)((StreamConfigurationCreate.Builder)StreamConfigurationCreate.builder().applyMutation(streamConfiguration)).build());
        }

        public Builder studioComponentIds(Collection<String> var1);

        public Builder studioComponentIds(String ... var1);

        public Builder studioId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

