/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse;
import software.amazon.awssdk.services.nimble.model.StreamingSession;

public class ListStreamingSessionsPublisher
implements SdkPublisher<ListStreamingSessionsResponse> {
    private final NimbleAsyncClient client;
    private final ListStreamingSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamingSessionsPublisher(NimbleAsyncClient client, ListStreamingSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamingSessionsPublisher(NimbleAsyncClient client, ListStreamingSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamingSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamingSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamingSession> sessions() {
        Function<ListStreamingSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessions() != null) {
                return response.sessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamingSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamingSessionsResponseFetcher
    implements AsyncPageFetcher<ListStreamingSessionsResponse> {
        private ListStreamingSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamingSessionsResponse> nextPage(ListStreamingSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingSessionsPublisher.this.client.listStreamingSessions(ListStreamingSessionsPublisher.this.firstRequest);
            }
            return ListStreamingSessionsPublisher.this.client.listStreamingSessions((ListStreamingSessionsRequest)((Object)ListStreamingSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

