/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse;
import software.amazon.awssdk.services.nimble.model.StreamingSession;

public class ListStreamingSessionsIterable
implements SdkIterable<ListStreamingSessionsResponse> {
    private final NimbleClient client;
    private final ListStreamingSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamingSessionsIterable(NimbleClient client, ListStreamingSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamingSessionsResponseFetcher();
    }

    public Iterator<ListStreamingSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamingSession> sessions() {
        Function<ListStreamingSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessions() != null) {
                return response.sessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamingSessionsResponseFetcher
    implements SyncPageFetcher<ListStreamingSessionsResponse> {
        private ListStreamingSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamingSessionsResponse nextPage(ListStreamingSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingSessionsIterable.this.client.listStreamingSessions(ListStreamingSessionsIterable.this.firstRequest);
            }
            return ListStreamingSessionsIterable.this.client.listStreamingSessions((ListStreamingSessionsRequest)((Object)ListStreamingSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

