/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.LaunchProfile;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse;

public class ListLaunchProfilesIterable
implements SdkIterable<ListLaunchProfilesResponse> {
    private final NimbleClient client;
    private final ListLaunchProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLaunchProfilesIterable(NimbleClient client, ListLaunchProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLaunchProfilesResponseFetcher();
    }

    public Iterator<ListLaunchProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchProfile> launchProfiles() {
        Function<ListLaunchProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchProfiles() != null) {
                return response.launchProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLaunchProfilesResponseFetcher
    implements SyncPageFetcher<ListLaunchProfilesResponse> {
        private ListLaunchProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLaunchProfilesResponse nextPage(ListLaunchProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchProfilesIterable.this.client.listLaunchProfiles(ListLaunchProfilesIterable.this.firstRequest);
            }
            return ListLaunchProfilesIterable.this.client.listLaunchProfiles((ListLaunchProfilesRequest)((Object)ListLaunchProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

