/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.Eula;
import software.amazon.awssdk.services.nimble.model.EulaListCopier;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEulasResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListEulasResponse> {
    private static final SdkField<List<Eula>> EULAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eulas").getter(ListEulasResponse.getter(ListEulasResponse::eulas)).setter(ListEulasResponse.setter(Builder::eulas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Eula::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEulasResponse.getter(ListEulasResponse::nextToken)).setter(ListEulasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EULAS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Eula> eulas;
    private final String nextToken;

    private ListEulasResponse(BuilderImpl builder) {
        super(builder);
        this.eulas = builder.eulas;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEulas() {
        return this.eulas != null && !(this.eulas instanceof SdkAutoConstructList);
    }

    public final List<Eula> eulas() {
        return this.eulas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEulas() ? this.eulas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEulasResponse)) {
            return false;
        }
        ListEulasResponse other = (ListEulasResponse)((Object)obj);
        return this.hasEulas() == other.hasEulas() && Objects.equals(this.eulas(), other.eulas()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEulasResponse").add("Eulas", this.hasEulas() ? this.eulas() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eulas": {
                return Optional.ofNullable(clazz.cast(this.eulas()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEulasResponse, T> g) {
        return obj -> g.apply((ListEulasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private List<Eula> eulas = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEulasResponse model) {
            super(model);
            this.eulas(model.eulas);
            this.nextToken(model.nextToken);
        }

        public final List<Eula.Builder> getEulas() {
            List<Eula.Builder> result = EulaListCopier.copyToBuilder(this.eulas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEulas(Collection<Eula.BuilderImpl> eulas) {
            this.eulas = EulaListCopier.copyFromBuilder(eulas);
        }

        @Override
        public final Builder eulas(Collection<Eula> eulas) {
            this.eulas = EulaListCopier.copy(eulas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulas(Eula ... eulas) {
            this.eulas(Arrays.asList(eulas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulas(Consumer<Eula.Builder> ... eulas) {
            this.eulas(Stream.of(eulas).map(c -> (Eula)((Eula.Builder)Eula.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEulasResponse build() {
            return new ListEulasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEulasResponse> {
        public Builder eulas(Collection<Eula> var1);

        public Builder eulas(Eula ... var1);

        public Builder eulas(Consumer<Eula.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

