/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.SessionBackupMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamConfigurationSessionBackup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamConfigurationSessionBackup> {
    private static final SdkField<Integer> MAX_BACKUPS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBackupsToRetain").getter(StreamConfigurationSessionBackup.getter(StreamConfigurationSessionBackup::maxBackupsToRetain)).setter(StreamConfigurationSessionBackup.setter(Builder::maxBackupsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBackupsToRetain").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(StreamConfigurationSessionBackup.getter(StreamConfigurationSessionBackup::modeAsString)).setter(StreamConfigurationSessionBackup.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_BACKUPS_TO_RETAIN_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxBackupsToRetain;
    private final String mode;

    private StreamConfigurationSessionBackup(BuilderImpl builder) {
        this.maxBackupsToRetain = builder.maxBackupsToRetain;
        this.mode = builder.mode;
    }

    public final Integer maxBackupsToRetain() {
        return this.maxBackupsToRetain;
    }

    public final SessionBackupMode mode() {
        return SessionBackupMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBackupsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationSessionBackup)) {
            return false;
        }
        StreamConfigurationSessionBackup other = (StreamConfigurationSessionBackup)obj;
        return Objects.equals(this.maxBackupsToRetain(), other.maxBackupsToRetain()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StreamConfigurationSessionBackup").add("MaxBackupsToRetain", (Object)this.maxBackupsToRetain()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxBackupsToRetain": {
                return Optional.ofNullable(clazz.cast(this.maxBackupsToRetain()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamConfigurationSessionBackup, T> g) {
        return obj -> g.apply((StreamConfigurationSessionBackup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxBackupsToRetain;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamConfigurationSessionBackup model) {
            this.maxBackupsToRetain(model.maxBackupsToRetain);
            this.mode(model.mode);
        }

        public final Integer getMaxBackupsToRetain() {
            return this.maxBackupsToRetain;
        }

        public final void setMaxBackupsToRetain(Integer maxBackupsToRetain) {
            this.maxBackupsToRetain = maxBackupsToRetain;
        }

        @Override
        public final Builder maxBackupsToRetain(Integer maxBackupsToRetain) {
            this.maxBackupsToRetain = maxBackupsToRetain;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(SessionBackupMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public StreamConfigurationSessionBackup build() {
            return new StreamConfigurationSessionBackup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamConfigurationSessionBackup> {
        public Builder maxBackupsToRetain(Integer var1);

        public Builder mode(String var1);

        public Builder mode(SessionBackupMode var1);
    }
}

