/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.StreamingSessionState;
import software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingSessionBackup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingSessionBackup> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(StreamingSessionBackup.getter(StreamingSessionBackup::arn)).setter(StreamingSessionBackup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backupId").getter(StreamingSessionBackup.getter(StreamingSessionBackup::backupId)).setter(StreamingSessionBackup.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StreamingSessionBackup.getter(StreamingSessionBackup::createdAt)).setter(StreamingSessionBackup.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileId").getter(StreamingSessionBackup.getter(StreamingSessionBackup::launchProfileId)).setter(StreamingSessionBackup.setter(Builder::launchProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()}).build();
    private static final SdkField<String> OWNED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownedBy").getter(StreamingSessionBackup.getter(StreamingSessionBackup::ownedBy)).setter(StreamingSessionBackup.setter(Builder::ownedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(StreamingSessionBackup.getter(StreamingSessionBackup::sessionId)).setter(StreamingSessionBackup.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(StreamingSessionBackup.getter(StreamingSessionBackup::stateAsString)).setter(StreamingSessionBackup.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(StreamingSessionBackup.getter(StreamingSessionBackup::statusCodeAsString)).setter(StreamingSessionBackup.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(StreamingSessionBackup.getter(StreamingSessionBackup::statusMessage)).setter(StreamingSessionBackup.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StreamingSessionBackup.getter(StreamingSessionBackup::tags)).setter(StreamingSessionBackup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BACKUP_ID_FIELD, CREATED_AT_FIELD, LAUNCH_PROFILE_ID_FIELD, OWNED_BY_FIELD, SESSION_ID_FIELD, STATE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String backupId;
    private final Instant createdAt;
    private final String launchProfileId;
    private final String ownedBy;
    private final String sessionId;
    private final String state;
    private final String statusCodeValue;
    private final String statusMessage;
    private final Map<String, String> tags;

    private StreamingSessionBackup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.backupId = builder.backupId;
        this.createdAt = builder.createdAt;
        this.launchProfileId = builder.launchProfileId;
        this.ownedBy = builder.ownedBy;
        this.sessionId = builder.sessionId;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String backupId() {
        return this.backupId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String launchProfileId() {
        return this.launchProfileId;
    }

    public final String ownedBy() {
        return this.ownedBy;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final StreamingSessionState state() {
        return StreamingSessionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StreamingSessionStatusCode statusCode() {
        return StreamingSessionStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingSessionBackup)) {
            return false;
        }
        StreamingSessionBackup other = (StreamingSessionBackup)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.launchProfileId(), other.launchProfileId()) && Objects.equals(this.ownedBy(), other.ownedBy()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingSessionBackup").add("Arn", (Object)this.arn()).add("BackupId", (Object)this.backupId()).add("CreatedAt", (Object)this.createdAt()).add("LaunchProfileId", (Object)this.launchProfileId()).add("OwnedBy", (Object)this.ownedBy()).add("SessionId", (Object)this.sessionId()).add("State", (Object)this.stateAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "backupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "launchProfileId": {
                return Optional.ofNullable(clazz.cast(this.launchProfileId()));
            }
            case "ownedBy": {
                return Optional.ofNullable(clazz.cast(this.ownedBy()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingSessionBackup, T> g) {
        return obj -> g.apply((StreamingSessionBackup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String backupId;
        private Instant createdAt;
        private String launchProfileId;
        private String ownedBy;
        private String sessionId;
        private String state;
        private String statusCodeValue;
        private String statusMessage;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingSessionBackup model) {
            this.arn(model.arn);
            this.backupId(model.backupId);
            this.createdAt(model.createdAt);
            this.launchProfileId(model.launchProfileId);
            this.ownedBy(model.ownedBy);
            this.sessionId(model.sessionId);
            this.state(model.state);
            this.statusCode(model.statusCodeValue);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getLaunchProfileId() {
            return this.launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamingSessionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(StreamingSessionStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public StreamingSessionBackup build() {
            return new StreamingSessionBackup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingSessionBackup> {
        public Builder arn(String var1);

        public Builder backupId(String var1);

        public Builder createdAt(Instant var1);

        public Builder launchProfileId(String var1);

        public Builder ownedBy(String var1);

        public Builder sessionId(String var1);

        public Builder state(String var1);

        public Builder state(StreamingSessionState var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StreamingSessionStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

