/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttachmentErrorCode {
    VPC_NOT_FOUND("VPC_NOT_FOUND"),
    SUBNET_NOT_FOUND("SUBNET_NOT_FOUND"),
    SUBNET_DUPLICATED_IN_AVAILABILITY_ZONE("SUBNET_DUPLICATED_IN_AVAILABILITY_ZONE"),
    SUBNET_NO_FREE_ADDRESSES("SUBNET_NO_FREE_ADDRESSES"),
    SUBNET_UNSUPPORTED_AVAILABILITY_ZONE("SUBNET_UNSUPPORTED_AVAILABILITY_ZONE"),
    SUBNET_NO_IPV6_CIDRS("SUBNET_NO_IPV6_CIDRS"),
    VPN_CONNECTION_NOT_FOUND("VPN_CONNECTION_NOT_FOUND"),
    MAXIMUM_NO_ENCAP_LIMIT_EXCEEDED("MAXIMUM_NO_ENCAP_LIMIT_EXCEEDED"),
    DIRECT_CONNECT_GATEWAY_NOT_FOUND("DIRECT_CONNECT_GATEWAY_NOT_FOUND"),
    DIRECT_CONNECT_GATEWAY_EXISTING_ATTACHMENTS("DIRECT_CONNECT_GATEWAY_EXISTING_ATTACHMENTS"),
    DIRECT_CONNECT_GATEWAY_NO_PRIVATE_VIF("DIRECT_CONNECT_GATEWAY_NO_PRIVATE_VIF"),
    VPN_EXISTING_ASSOCIATIONS("VPN_EXISTING_ASSOCIATIONS"),
    VPC_UNSUPPORTED_FEATURES("VPC_UNSUPPORTED_FEATURES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttachmentErrorCode> VALUE_MAP;
    private final String value;

    private AttachmentErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttachmentErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttachmentErrorCode> knownValues() {
        EnumSet<AttachmentErrorCode> knownValues = EnumSet.allOf(AttachmentErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttachmentErrorCode.class, AttachmentErrorCode::toString);
    }
}

