/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummaryListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCoreNetworksResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, ListCoreNetworksResponse> {
    private static final SdkField<List<CoreNetworkSummary>> CORE_NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CoreNetworks").getter(ListCoreNetworksResponse.getter(ListCoreNetworksResponse::coreNetworks)).setter(ListCoreNetworksResponse.setter(Builder::coreNetworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoreNetworkSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCoreNetworksResponse.getter(ListCoreNetworksResponse::nextToken)).setter(ListCoreNetworksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCoreNetworksResponse.memberNameToFieldInitializer();
    private final List<CoreNetworkSummary> coreNetworks;
    private final String nextToken;

    private ListCoreNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetworks = builder.coreNetworks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCoreNetworks() {
        return this.coreNetworks != null && !(this.coreNetworks instanceof SdkAutoConstructList);
    }

    public final List<CoreNetworkSummary> coreNetworks() {
        return this.coreNetworks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoreNetworks() ? this.coreNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreNetworksResponse)) {
            return false;
        }
        ListCoreNetworksResponse other = (ListCoreNetworksResponse)((Object)obj);
        return this.hasCoreNetworks() == other.hasCoreNetworks() && Objects.equals(this.coreNetworks(), other.coreNetworks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCoreNetworksResponse").add("CoreNetworks", this.hasCoreNetworks() ? this.coreNetworks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworks": {
                return Optional.ofNullable(clazz.cast(this.coreNetworks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CoreNetworks", CORE_NETWORKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCoreNetworksResponse, T> g) {
        return obj -> g.apply((ListCoreNetworksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<CoreNetworkSummary> coreNetworks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreNetworksResponse model) {
            super(model);
            this.coreNetworks(model.coreNetworks);
            this.nextToken(model.nextToken);
        }

        public final List<CoreNetworkSummary.Builder> getCoreNetworks() {
            List<CoreNetworkSummary.Builder> result = CoreNetworkSummaryListCopier.copyToBuilder(this.coreNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoreNetworks(Collection<CoreNetworkSummary.BuilderImpl> coreNetworks) {
            this.coreNetworks = CoreNetworkSummaryListCopier.copyFromBuilder(coreNetworks);
        }

        @Override
        public final Builder coreNetworks(Collection<CoreNetworkSummary> coreNetworks) {
            this.coreNetworks = CoreNetworkSummaryListCopier.copy(coreNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworks(CoreNetworkSummary ... coreNetworks) {
            this.coreNetworks(Arrays.asList(coreNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coreNetworks(Consumer<CoreNetworkSummary.Builder> ... coreNetworks) {
            this.coreNetworks(Stream.of(coreNetworks).map(c -> (CoreNetworkSummary)((CoreNetworkSummary.Builder)CoreNetworkSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCoreNetworksResponse build() {
            return new ListCoreNetworksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCoreNetworksResponse> {
        public Builder coreNetworks(Collection<CoreNetworkSummary> var1);

        public Builder coreNetworks(CoreNetworkSummary ... var1);

        public Builder coreNetworks(Consumer<CoreNetworkSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

