/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkNetworkFunctionGroupIdentifier;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTableIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTableIdentifier> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableArn").getter(RouteTableIdentifier.getter(RouteTableIdentifier::transitGatewayRouteTableArn)).setter(RouteTableIdentifier.setter(Builder::transitGatewayRouteTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableArn").build()}).build();
    private static final SdkField<CoreNetworkSegmentEdgeIdentifier> CORE_NETWORK_SEGMENT_EDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CoreNetworkSegmentEdge").getter(RouteTableIdentifier.getter(RouteTableIdentifier::coreNetworkSegmentEdge)).setter(RouteTableIdentifier.setter(Builder::coreNetworkSegmentEdge)).constructor(CoreNetworkSegmentEdgeIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkSegmentEdge").build()}).build();
    private static final SdkField<CoreNetworkNetworkFunctionGroupIdentifier> CORE_NETWORK_NETWORK_FUNCTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CoreNetworkNetworkFunctionGroup").getter(RouteTableIdentifier.getter(RouteTableIdentifier::coreNetworkNetworkFunctionGroup)).setter(RouteTableIdentifier.setter(Builder::coreNetworkNetworkFunctionGroup)).constructor(CoreNetworkNetworkFunctionGroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkNetworkFunctionGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD, CORE_NETWORK_SEGMENT_EDGE_FIELD, CORE_NETWORK_NETWORK_FUNCTION_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteTableIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayRouteTableArn;
    private final CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge;
    private final CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup;

    private RouteTableIdentifier(BuilderImpl builder) {
        this.transitGatewayRouteTableArn = builder.transitGatewayRouteTableArn;
        this.coreNetworkSegmentEdge = builder.coreNetworkSegmentEdge;
        this.coreNetworkNetworkFunctionGroup = builder.coreNetworkNetworkFunctionGroup;
    }

    public final String transitGatewayRouteTableArn() {
        return this.transitGatewayRouteTableArn;
    }

    public final CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge() {
        return this.coreNetworkSegmentEdge;
    }

    public final CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup() {
        return this.coreNetworkNetworkFunctionGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkSegmentEdge());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkNetworkFunctionGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTableIdentifier)) {
            return false;
        }
        RouteTableIdentifier other = (RouteTableIdentifier)obj;
        return Objects.equals(this.transitGatewayRouteTableArn(), other.transitGatewayRouteTableArn()) && Objects.equals(this.coreNetworkSegmentEdge(), other.coreNetworkSegmentEdge()) && Objects.equals(this.coreNetworkNetworkFunctionGroup(), other.coreNetworkNetworkFunctionGroup());
    }

    public final String toString() {
        return ToString.builder((String)"RouteTableIdentifier").add("TransitGatewayRouteTableArn", (Object)this.transitGatewayRouteTableArn()).add("CoreNetworkSegmentEdge", (Object)this.coreNetworkSegmentEdge()).add("CoreNetworkNetworkFunctionGroup", (Object)this.coreNetworkNetworkFunctionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTableArn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableArn()));
            }
            case "CoreNetworkSegmentEdge": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkSegmentEdge()));
            }
            case "CoreNetworkNetworkFunctionGroup": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkNetworkFunctionGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayRouteTableArn", TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD);
        map.put("CoreNetworkSegmentEdge", CORE_NETWORK_SEGMENT_EDGE_FIELD);
        map.put("CoreNetworkNetworkFunctionGroup", CORE_NETWORK_NETWORK_FUNCTION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTableIdentifier, T> g) {
        return obj -> g.apply((RouteTableIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayRouteTableArn;
        private CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge;
        private CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTableIdentifier model) {
            this.transitGatewayRouteTableArn(model.transitGatewayRouteTableArn);
            this.coreNetworkSegmentEdge(model.coreNetworkSegmentEdge);
            this.coreNetworkNetworkFunctionGroup(model.coreNetworkNetworkFunctionGroup);
        }

        public final String getTransitGatewayRouteTableArn() {
            return this.transitGatewayRouteTableArn;
        }

        public final void setTransitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
        }

        @Override
        public final Builder transitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
            return this;
        }

        public final CoreNetworkSegmentEdgeIdentifier.Builder getCoreNetworkSegmentEdge() {
            return this.coreNetworkSegmentEdge != null ? this.coreNetworkSegmentEdge.toBuilder() : null;
        }

        public final void setCoreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier.BuilderImpl coreNetworkSegmentEdge) {
            this.coreNetworkSegmentEdge = coreNetworkSegmentEdge != null ? coreNetworkSegmentEdge.build() : null;
        }

        @Override
        public final Builder coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge) {
            this.coreNetworkSegmentEdge = coreNetworkSegmentEdge;
            return this;
        }

        public final CoreNetworkNetworkFunctionGroupIdentifier.Builder getCoreNetworkNetworkFunctionGroup() {
            return this.coreNetworkNetworkFunctionGroup != null ? this.coreNetworkNetworkFunctionGroup.toBuilder() : null;
        }

        public final void setCoreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier.BuilderImpl coreNetworkNetworkFunctionGroup) {
            this.coreNetworkNetworkFunctionGroup = coreNetworkNetworkFunctionGroup != null ? coreNetworkNetworkFunctionGroup.build() : null;
        }

        @Override
        public final Builder coreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup) {
            this.coreNetworkNetworkFunctionGroup = coreNetworkNetworkFunctionGroup;
            return this;
        }

        public RouteTableIdentifier build() {
            return new RouteTableIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTableIdentifier> {
        public Builder transitGatewayRouteTableArn(String var1);

        public Builder coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier var1);

        default public Builder coreNetworkSegmentEdge(Consumer<CoreNetworkSegmentEdgeIdentifier.Builder> coreNetworkSegmentEdge) {
            return this.coreNetworkSegmentEdge((CoreNetworkSegmentEdgeIdentifier)((CoreNetworkSegmentEdgeIdentifier.Builder)CoreNetworkSegmentEdgeIdentifier.builder().applyMutation(coreNetworkSegmentEdge)).build());
        }

        public Builder coreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier var1);

        default public Builder coreNetworkNetworkFunctionGroup(Consumer<CoreNetworkNetworkFunctionGroupIdentifier.Builder> coreNetworkNetworkFunctionGroup) {
            return this.coreNetworkNetworkFunctionGroup((CoreNetworkNetworkFunctionGroupIdentifier)((CoreNetworkNetworkFunctionGroupIdentifier.Builder)CoreNetworkNetworkFunctionGroupIdentifier.builder().applyMutation(coreNetworkNetworkFunctionGroup)).build());
        }
    }
}

