/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.Bandwidth;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLinkRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, UpdateLinkRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(UpdateLinkRequest.getter(UpdateLinkRequest::globalNetworkId)).setter(UpdateLinkRequest.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkId").getter(UpdateLinkRequest.getter(UpdateLinkRequest::linkId)).setter(UpdateLinkRequest.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("linkId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateLinkRequest.getter(UpdateLinkRequest::description)).setter(UpdateLinkRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateLinkRequest.getter(UpdateLinkRequest::type)).setter(UpdateLinkRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Bandwidth> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bandwidth").getter(UpdateLinkRequest.getter(UpdateLinkRequest::bandwidth)).setter(UpdateLinkRequest.setter(Builder::bandwidth)).constructor(Bandwidth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bandwidth").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(UpdateLinkRequest.getter(UpdateLinkRequest::provider)).setter(UpdateLinkRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, LINK_ID_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, BANDWIDTH_FIELD, PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLinkRequest.memberNameToFieldInitializer();
    private final String globalNetworkId;
    private final String linkId;
    private final String description;
    private final String type;
    private final Bandwidth bandwidth;
    private final String provider;

    private UpdateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.linkId = builder.linkId;
        this.description = builder.description;
        this.type = builder.type;
        this.bandwidth = builder.bandwidth;
        this.provider = builder.provider;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final String description() {
        return this.description;
    }

    public final String type() {
        return this.type;
    }

    public final Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public final String provider() {
        return this.provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkRequest)) {
            return false;
        }
        UpdateLinkRequest other = (UpdateLinkRequest)((Object)obj);
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.provider(), other.provider());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLinkRequest").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("LinkId", (Object)this.linkId()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("Bandwidth", (Object)this.bandwidth()).add("Provider", (Object)this.provider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "LinkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("globalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Bandwidth", BANDWIDTH_FIELD);
        map.put("Provider", PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkRequest, T> g) {
        return obj -> g.apply((UpdateLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private String linkId;
        private String description;
        private String type;
        private Bandwidth bandwidth;
        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkRequest model) {
            super(model);
            this.globalNetworkId(model.globalNetworkId);
            this.linkId(model.linkId);
            this.description(model.description);
            this.type(model.type);
            this.bandwidth(model.bandwidth);
            this.provider(model.provider);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Bandwidth.Builder getBandwidth() {
            return this.bandwidth != null ? this.bandwidth.toBuilder() : null;
        }

        public final void setBandwidth(Bandwidth.BuilderImpl bandwidth) {
            this.bandwidth = bandwidth != null ? bandwidth.build() : null;
        }

        @Override
        public final Builder bandwidth(Bandwidth bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLinkRequest build() {
            return new UpdateLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLinkRequest> {
        public Builder globalNetworkId(String var1);

        public Builder linkId(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder bandwidth(Bandwidth var1);

        default public Builder bandwidth(Consumer<Bandwidth.Builder> bandwidth) {
            return this.bandwidth((Bandwidth)((Bandwidth.Builder)Bandwidth.builder().applyMutation(bandwidth)).build());
        }

        public Builder provider(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

