/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.Attachment;
import software.amazon.awssdk.services.networkmanager.model.SubnetArnListCopier;
import software.amazon.awssdk.services.networkmanager.model.VpcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcAttachment> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(VpcAttachment.getter(VpcAttachment::attachment)).setter(VpcAttachment.setter(Builder::attachment)).constructor(Attachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()}).build();
    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetArns").getter(VpcAttachment.getter(VpcAttachment::subnetArns)).setter(VpcAttachment.setter(Builder::subnetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(VpcAttachment.getter(VpcAttachment::options)).setter(VpcAttachment.setter(Builder::options)).constructor(VpcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, SUBNET_ARNS_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Attachment", ATTACHMENT_FIELD);
            this.put("SubnetArns", SUBNET_ARNS_FIELD);
            this.put("Options", OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Attachment attachment;
    private final List<String> subnetArns;
    private final VpcOptions options;

    private VpcAttachment(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.subnetArns = builder.subnetArns;
        this.options = builder.options;
    }

    public final Attachment attachment() {
        return this.attachment;
    }

    public final boolean hasSubnetArns() {
        return this.subnetArns != null && !(this.subnetArns instanceof SdkAutoConstructList);
    }

    public final List<String> subnetArns() {
        return this.subnetArns;
    }

    public final VpcOptions options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetArns() ? this.subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcAttachment)) {
            return false;
        }
        VpcAttachment other = (VpcAttachment)obj;
        return Objects.equals(this.attachment(), other.attachment()) && this.hasSubnetArns() == other.hasSubnetArns() && Objects.equals(this.subnetArns(), other.subnetArns()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"VpcAttachment").add("Attachment", (Object)this.attachment()).add("SubnetArns", this.hasSubnetArns() ? this.subnetArns() : null).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "SubnetArns": {
                return Optional.ofNullable(clazz.cast(this.subnetArns()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcAttachment, T> g) {
        return obj -> g.apply((VpcAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Attachment attachment;
        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();
        private VpcOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcAttachment model) {
            this.attachment(model.attachment);
            this.subnetArns(model.subnetArns);
            this.options(model.options);
        }

        public final Attachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final Collection<String> getSubnetArns() {
            if (this.subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetArns;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String ... subnetArns) {
            this.subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final VpcOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(VpcOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(VpcOptions options) {
            this.options = options;
            return this;
        }

        public VpcAttachment build() {
            return new VpcAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcAttachment> {
        public Builder attachment(Attachment var1);

        default public Builder attachment(Consumer<Attachment.Builder> attachment) {
            return this.attachment((Attachment)((Attachment.Builder)Attachment.builder().applyMutation(attachment)).build());
        }

        public Builder subnetArns(Collection<String> var1);

        public Builder subnetArns(String ... var1);

        public Builder options(VpcOptions var1);

        default public Builder options(Consumer<VpcOptions.Builder> options) {
            return this.options((VpcOptions)((VpcOptions.Builder)VpcOptions.builder().applyMutation(options)).build());
        }
    }
}

