/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountStatus.getter(AccountStatus::accountId)).setter(AccountStatus.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> SLR_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SLRDeploymentStatus").getter(AccountStatus.getter(AccountStatus::slrDeploymentStatus)).setter(AccountStatus.setter(Builder::slrDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SLRDeploymentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, SLR_DEPLOYMENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("SLRDeploymentStatus", SLR_DEPLOYMENT_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String slrDeploymentStatus;

    private AccountStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.slrDeploymentStatus = builder.slrDeploymentStatus;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String slrDeploymentStatus() {
        return this.slrDeploymentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.slrDeploymentStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountStatus)) {
            return false;
        }
        AccountStatus other = (AccountStatus)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.slrDeploymentStatus(), other.slrDeploymentStatus());
    }

    public final String toString() {
        return ToString.builder((String)"AccountStatus").add("AccountId", (Object)this.accountId()).add("SLRDeploymentStatus", (Object)this.slrDeploymentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "SLRDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.slrDeploymentStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountStatus, T> g) {
        return obj -> g.apply((AccountStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String slrDeploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountStatus model) {
            this.accountId(model.accountId);
            this.slrDeploymentStatus(model.slrDeploymentStatus);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSlrDeploymentStatus() {
            return this.slrDeploymentStatus;
        }

        public final void setSlrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
        }

        @Override
        public final Builder slrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
            return this;
        }

        public AccountStatus build() {
            return new AccountStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountStatus> {
        public Builder accountId(String var1);

        public Builder slrDeploymentStatus(String var1);
    }
}

